import p2pmpi.mpi.*;
import java.lang.*;

public class Bcast {
      public static int VECTSIZE=100;

	public static void main(String[] args) {

		MPI.Init(args);
		int me  = MPI.COMM_WORLD.Rank();
		int size    = MPI.COMM_WORLD.Size();
            int root;
		int[] buff = new int[VECTSIZE];
            
            // -- single value broadcast
		for (root=0;root<size;root++) {
                  buff[0] = root;
                  if (me==root) 
                          System.out.println("[rank "+me+"] Broadcast single value "+buff[0]);
                  System.out.print("[rank "+me+"] Root is now rank "+root+". Expecting to receive "+
                                    root+". Received ... ");

                  MPI.COMM_WORLD.Bcast(buff, 0, 1, MPI.INT, root);
                  System.out.print(buff[0]);

                  // -- now all processes must have received root's buffer. Check this.
                  if (buff[0] != root) {
                          System.err.println("** Error: Bcast test failed: process "+
                                             me+" received "+buff[0]+" when root broadcasted "+root);
                          System.exit(1);
                  }
			System.out.println(". ok.");
            }
            // -- vector of values broadcast
		for (root=0;root<size;root++) {
                  int i;
			for (i=0;i<VECTSIZE;i++) buff[i] = root;
                  if (me==root) 
                          System.out.println("[rank "+me+"] Broadcast vector of values "+buff[VECTSIZE-1]);
                  System.out.print("[rank "+me+"] Root is now rank "+root+". Expecting to receive "
					       +VECTSIZE+" values "+root+". Received ... ");

                  MPI.COMM_WORLD.Bcast(buff, 0, VECTSIZE, MPI.INT, root);
                  System.out.print(buff[VECTSIZE-1]);

                  // -- now all processes must have received root's buffer. Check this.
			for (i=0;i<VECTSIZE;i++) {
                      if (buff[i] != root) {
                          System.err.println("** Error: Bcast test failed: process "+
                                             me+" received "+buff[i]+" at position "+i+
							   "in buffer, when root broadcasted "+root);
                          System.exit(1);
			    }
                  }
			System.out.println(". ok.");
            }

		MPI.Finalize();	
	}
}
