import p2pmpi.mpi.*;
public class SendMatrix2D
{
	public static void main(String[] args)
	{
		int x[][] = new int[10][10];
		int y[][] = new int[10][10];

		MPI.Init(args);
		int rank = MPI.COMM_WORLD.Rank();
		int size = MPI.COMM_WORLD.Size();
		if(size != 2) {
			System.out.println("Please run test with -n 2 option");
			MPI.Finalize();
		}
		//Generate value for matrix X
		for(int i = 0; i < 10; i++) {
			for(int j = 0; j < 10; j++) {
				x[i][j] = i;
				y[i][j] = 0;
			}
		}
		//Rank 0 sends matrix X, and Rank 1 store it in Y
		//Test to send 2 lines each time
		for(int i = 0; i < 10; i+=2) {
			if(rank == 0) {
				MPI.COMM_WORLD.Send(x, i, 2, MPI.OBJECT, 1, 10);
			} else {
				MPI.COMM_WORLD.Recv(y, i, 2, MPI.OBJECT, 0, 10);
			}
		}
		//Display value of matrix Y on Rank 1
		if(rank != 0) {
			for(int i = 0; i < 10; i++) {
				System.out.println("y["+i+"][5] = " + y[i][5]);
			}
		}
		MPI.Finalize();
	}
}
