import p2pmpi.mpi.*;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;


// ---- to be tested with 3 nodes. !!


public class RemoteDataTest {
	public static void main(String[] args) {
		int rank, size;

		MPI.Init(args);
		double startTime = MPI.Wtime();

		size = MPI.COMM_WORLD.Size();
		rank = MPI.COMM_WORLD.Rank();

		String myfilename = new String("sample.dat");
            File myfile = new File(myfilename);
		int len = (int) myfile.length();
		
		
		int vlen [] = new int [1];
		//----- rank 0 broadcasts the file length to all other processes
		if (rank == 0) 
			  vlen [0] = len;

		MPI.COMM_WORLD.Bcast(vlen, 0, 1, MPI.INT, 0);

		//----- all processes except 0 compare the length received with 
		//----- the length of the file received file 
		
		if (rank > 0) {
			if (len != vlen[0]) {
				System.err.println("[Error] received length ("+vlen[0]
							  +") differ from length of fuile transfered ("+len+")"); 
				MPI.Finalize();
				System.exit(1);
			}
		}
		
		// --- now, compares contents
		
		char rfile [] = new char [len];  // received file through MPI.Bcast
		char sfile [] = new char [len];  // file transfered with p2pmpirun -l

		if (rank ==0) { //-- rank 0 send its file contents
			try {
				BufferedReader fd = new BufferedReader(new FileReader(myfilename));
				fd.read( (char []) rfile, 0, len );
			} catch (Exception e) { 
				e.printStackTrace();
			}
		}
		
		MPI.COMM_WORLD.Bcast(rfile, 0, len, MPI.CHAR, 0);

		if (rank > 0) { //-- other ranks compare message received with file received (stored on disk)
			try {
				BufferedReader fd = new BufferedReader(new FileReader(myfilename));
				fd.read( (char []) sfile, 0, len );
			} catch (Exception e) { 
				e.printStackTrace();
			}
			String sfile_ = new String( sfile );
			String rfile_ = new String( rfile );
			if (!(sfile_.equals(rfile_))) {
			   System.err.println("[Error] read on disk   :"+sfile_);
			   System.err.println("        received BCAST :"+rfile_);
			}
			else {
			   System.err.println("[Succes] File transfer ok.");
			}
		}
		MPI.Finalize();
	}
}
