package p2pmpi.p2p;

import java.util.*;
import java.net.*;
import java.io.*;
import p2pmpi.common.*;
import p2pmpi.p2p.message.*;

public class PeerUpdateList extends TimerTask {
	URI superNode;
	HostEntry myHost;
	HashMap<String, HostEntry> hostCache;


	public PeerUpdateList(URI superNode, HostEntry myHost, HashMap<String, HostEntry> hostCache) {
		this.superNode = superNode;
		this.myHost = myHost;
		this.hostCache = hostCache;
	}

	public void run() {
		try {
			Socket sock = new Socket(superNode.getHost(), superNode.getPort());
			PeerRequestMessage msg = new PeerRequestMessage();
			InputStream in = sock.getInputStream();
			OutputStream out = sock.getOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(out);
			oos.writeObject(msg);
			oos.flush();
			ObjectInputStream ois = new ObjectInputStream(in);
			PeerReplyMessage replyMsg = (PeerReplyMessage)ois.readObject();
			ois.close();
			oos.close();
			in.close();
			out.close();
			sock.close();

			Vector<HostEntry> hostList = replyMsg.getHostList();
			int size = hostList.size();
			for(int i = 0; i < size; i++) {
				HostEntry entry = hostList.elementAt(i);
				if(entry.toString().equals(myHost.toString())) {
					continue;
				}
				String hashMapKey = entry.toString();

				if (!hostCache.containsKey(hashMapKey)) {
					//Ping to update RTT
					PingRTT rttChecker = new PingRTT(entry.getIp(), entry.getMpdPort());
					int rtt = rttChecker.ping();
					entry.setRtt(rtt);
					entry.setAlive(true);
					entry.setLastUpdate();
					// Put entry to hashCache
					hostCache.put(hashMapKey, entry);
				} else {
					//Check last update if pass sometime we ping and keep minimum 5 min
					if(hostCache.get(hashMapKey).getLastUpdate() > 300000) {
						PingRTT rttChecker = new PingRTT(entry.getIp(), entry.getMpdPort());
						int rtt = rttChecker.ping();
						hostCache.get(hashMapKey).setRtt(rtt);
						hostCache.get(hashMapKey).setLastUpdate();
					}
					hostCache.get(hashMapKey).setAlive(true);
				}
			}
		} catch(Exception e) {
		}
	}
}
