package p2pmpi.mpi.dev;

/**
 * The handle of asynchronous communication
 */
public class SmallRequest {
	volatile boolean completed;
	int rankInList;
	/**
	 * Internal use
	 */
	public SmallRequest()
	{
		completed 	= false;
	}

	public SmallRequest(int rankInList) 
	{
		completed = false;
		this.rankInList = rankInList;
	}

	public synchronized void complete() {
		completed = true;
		notify();
	}

	public int getRankInList() {
		return rankInList;
	}

	/**
	 * Blocks until a waiting asynchronous message is received
	 */
	public synchronized void Wait() {
		while(!completed) {
			try {
				wait();
			} catch(Exception e) {}
		}
	}
}
