package p2pmpi.mpi.dev;

import p2pmpi.common.*;

public class LargeMessagePendingInfo {
	RankTable commTable;
	int[] repRankInList;
	short commID;
	int src;
	int dst;
	int tag;
	int numsend;

	public LargeMessagePendingInfo(RankTable commTable, int[] repRankInList,
					short commID, int src, int dst, int tag, int numsend)
	{
		this.commTable = commTable;
		this.repRankInList = repRankInList;
		this.commID	= commID;
		this.src	= src;
		this.dst	= dst;
		this.tag	= tag;
		this.numsend	= numsend;
	}
	public String getKey() {
		return commID + "_" + src + "_" + dst + "_" + tag + "_" + numsend;
	}

	public RankTable getCommTable() {
		return commTable;
	}
	public int[] getRepRankInList() {
		return repRankInList;
	}
	public short getCommID() {
		return commID;
	}
	public int getSrc() {
		return src;
	}
	public int getDst() {
		return dst;
	}
	public int getTag() {
		return tag;
	}
	public int getNumSend() {
		return numsend;
	}
}
