package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferChar extends P2PMPI_Buffer {
	public BufferChar(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {

		CharBuffer charBuffer = myBuffer.asCharBuffer();
		charBuffer.put((char[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count * baseSize));

		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		int recvData;
		if(dataSize/baseSize < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;

		int end = offset+recvData;

		CharBuffer charBuffer = data.asCharBuffer();
		charBuffer.get((char[])buffer, offset, recvData);
		data.position(data.position() + (recvData * baseSize));

		return (count - recvData) * baseSize;
	}

        public Object createArrayBuffer(int count) {
	        return new char[count];
	}

}
