package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferByte extends P2PMPI_Buffer {
	public BufferByte(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		myBuffer.put((byte[])buffer, offset, count);
		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {

		data.get((byte[])buffer, offset, count);

		return (count-offset)*baseSize;
	}

	public Object createArrayBuffer(int count) {
		return new byte[count];
	}
}
