package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferBoolean extends P2PMPI_Buffer {
	public BufferBoolean(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		boolean[] booleanDat = (boolean[])buffer;
		int end = offset+count;

		for(int i = offset; i < end; i++) {
			byte value = (byte)((booleanDat[i])?1:0);
			myBuffer.put(value);
		}
		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		boolean[] booleanDat = (boolean[])buffer;
		int recvData;
		if(dataSize < count)
			recvData = dataSize;
		else
			recvData = count;

		int end = offset+recvData;

		for(int i = offset; i < end; i++) {
			booleanDat[i] = (data.get() != 0);
		}
		return (recvData - offset) * baseSize;
	}

        public Object createArrayBuffer(int count) {
	        return new boolean[count];
	}

}
