package p2pmpi.message;

import java.net.*;
import java.io.*;

public class FTMessage implements Serializable {
	private static final long serialVersionUID = 2000015L;
	//Common
	int cmd;
	String hashID;
	String[] fileList;
	String[] fileOnlyList;

	//REGISTER
	URI[] uriList;
	int[] keyList;
	int size;

	//Transfer
	int key;
	byte[][] fileContent;

	public FTMessage(int cmd, String hashID) {
		this.cmd = cmd;
		this.hashID = hashID;
	}

	public void setKeys(int[] keyList) {
		this.keyList = keyList;
	}

	public void setURIs(URI[] uriList) {
		this.uriList = uriList;
	}

	/**
	 * builds the list of short filenames
	 *
	 * @param fList list of Strings as read in the list passed as parameter to run command
	 **/
	public void setFileNames(String[] fList) {
		fileList = fList;   //  <-- Choopan, pourquoi une nouvelle variable ?
		int numFile = fileList.length;
		fileOnlyList = new String[numFile];
		for(int i = 0; i < numFile; i++) {
			if (fileList[i].startsWith("http://")) {
				fileOnlyList[i] = fileList[i];
			}
			else {
				File tmp = new File(fileList[i]);
				fileOnlyList[i] = tmp.getName();
			}
		}
	}

	/**
	 * loads files to be transfered into memory.
	 *
	 * @param fList the filenames list of files to load into memory
	 *
	 * The message to be sent will contain the files contents of files
	 * designated by their absolute path in the filelist passed as parameter
	 * (p2pmpirun -l). 
	 * To DO : If a file is designated as an URL, pass the URL not the file contents.  
	 **/
	public void setFileContent(String[] fList) {

		File tmpfile;
		FileInputStream files;
		int fileSize;
		fileContent = new byte[fList.length][];
		for(int i = 0; i < fList.length; i++) {
			tmpfile = new File(fList[i]);
			if (fList[i].startsWith("http://")) {
				fileContent[i] = new byte[56 /* FIX ME : md5sum length */];
				/* fileContent[i]= tmpfile.md5sum(); */
			}
			else {
				// Get file size
				tmpfile = new File(fList[i]);
				fileSize = (int)(tmpfile.length());
				// Read file
				try {
					fileContent[i] = new byte[fileSize];
					files = new FileInputStream(fList[i]);
					files.read(fileContent[i], 0, fileSize);
					files.close();
				} catch (Exception e) { 
					System.err.println("** [Error]  Could not read file " + fList[i] + " for transfer.");
                          		e.printStackTrace(); 
                  	}
			}
		}
	}

	public void setSize(int size) {
		this.size = size;
	}

	public int getCmd() {
		return cmd;
	}

	public String getID() {
		return hashID;
	}

	public int getKey(int index) {
		return keyList[index];
	}

	public URI getURI(int index) {
		return uriList[index];
	}

	public int size() {
		return size;
	}

	public String[] getFileNameList() {
		return fileList;
	}

	public String[] getOnlyFileNameList() {
		return fileOnlyList;
	}
	public String getFileName(int index) {
		return fileList[index];
	}

	public byte[] getFileContent(int index) {
		return fileContent[index];
	}
	public int getNumFile() {
		return fileList.length;
	}

	// Transfer
	public void setKey(int key) {
		this.key = key;
	}

	public int getKey() {
		return key;
	}
}
