package p2pmpi.message;

import java.io.*;
import java.nio.*;

public class DatMessage {
	public final static byte MAGIC_NUMBER = 13;
	ByteBuffer buffer;

	public final static byte CONNECT 		= 1;
	public final static byte DATA_MESSAGE 		= 2;
	public final static byte UPDATE_STATUS 		= 3;
	public final static byte FINALIZE 		= 4;
	public final static byte FINALIZE_CONFIRM 	= 5;
	public final static byte READY_TO_SEND		= 6;
	public final static byte READY_TO_RECV		= 7;

	public DatMessage(ByteBuffer buffer, byte messageType) {
		this.buffer = buffer;
		buffer.clear();
		buffer.put(MAGIC_NUMBER);
		buffer.put(messageType);
	}

	//return number total byte in buffer
	public int done() {
		buffer.flip();
		return buffer.limit();
	}

	public void pack(short data) throws BufferOverflowException {
		buffer.putShort(data);
	}

	public void pack(byte data) throws BufferOverflowException {
		buffer.put(data);
	}

	public void pack(int data) throws BufferOverflowException {
		buffer.putInt(data);
	}

	public void pack(String data) throws BufferOverflowException {
		buffer.put(data.getBytes());
	}

	public void pack(byte[] data) throws BufferOverflowException {
		buffer.put(data);
	}
	
}
