package p2pmpi.fd;

import p2pmpi.common.*;
import p2pmpi.message.*;
import java.net.*;
import java.io.*;
import java.util.*;
import org.apache.log4j.*;

public class DBRR extends GossipDetector {
	public DBRR(int myRank, String hashID, int mpiPort, URI[] uriList, 
			      int mpdPort, int mpiRank,
			      int t_gossip, int t_margin, 
			      int t_diff, long t_stamp, int t_hang) {

		super(myRank, hashID, mpiPort, uriList, mpdPort,
		      mpiRank, t_gossip, t_margin, t_diff, t_stamp, 
		      t_hang);

		T_MIN_CLEANUP = (long)(Math.ceil(Math.log(numPeers)/Math.log(2)))*2;
		T_CLEANUP = ((T_MIN_CLEANUP/2) * 3) + (long)(Math.ceil((double)T_MAX_HANG/(double)t_gossip)); //3 log_2(n) [dbrr]  + T_MAX_HANG

	}

	public int getNextDestination( int round) {
		if(round < T_MIN_CLEANUP/2) {
			//Do clokwise direction
			//System.err.println("Source = " + myRank + ", Round = " + round + ", numPeer = " + numPeers);
			//System.err.println("First half ->" + ((int)(myRank+Math.pow(2, round)) % numPeers));
			return ((int)(myRank+Math.pow(2, round)) % numPeers);
		} else {
			//Do counter-clockwise direction
			int tmpDest = (int)(myRank-Math.pow(2, round-(T_MIN_CLEANUP/2)));
			if(tmpDest < 0) {
				tmpDest += numPeers;
			} 
			//System.err.println("Source = " + myRank + ", Round = " + round + ", numPeer = " + numPeers + "T_MIN_CLEANUP=" + T_MIN_CLEANUP);
			//System.err.println("Return second half -> " + tmpDest);
			return tmpDest;
		}
	}

}
