package p2pmpi.fd;

import p2pmpi.common.*;
import p2pmpi.message.*;
import java.net.*;
import java.io.*;
import java.util.*;
import org.apache.log4j.*;

public class BRR extends GossipDetector {

	public BRR(int myRank, String hashID, int mpiPort, URI[] uriList, 
			      int mpdPort, int mpiRank,
			      int t_gossip, int t_margin, 
			      int t_diff, long t_stamp, int t_hang) {

		super(myRank, hashID, mpiPort, uriList, mpdPort,
		      mpiRank, t_gossip, t_margin, t_diff, t_stamp,
		      t_hang);

		T_MIN_CLEANUP = (long)(Math.ceil(Math.log(numPeers)/Math.log(2)));
		T_CLEANUP = (T_MIN_CLEANUP * 2) + (long)(Math.ceil((double)T_MAX_HANG/(double)t_gossip)); //2 log_2(n) [brr]  + T_MAX_HANG
	}

	public int getNextDestination(int round) {
		return (int)(myRank+Math.pow(2, round)) % numPeers;
	}

}
