package p2pmpi.common;

import java.io.*;
import java.net.*;
import java.util.*;

public class RankTable implements Serializable {
	private static final long serialVersionUID = 1000004L;

	Vector<TableInfo> table;
	int numProcess;
	int numReplica;


	public RankTable() {
		table = new Vector<TableInfo>();
	}

	public void addProcess(int rank, URI cmdURI, URI ctrlURI, URI dataURI, int fdPort) {
		TableInfo tableInfo = new TableInfo(rank, cmdURI, ctrlURI, dataURI, true, fdPort);
		table.addElement(tableInfo);
	}

	public void setNumProcess(int numProcess) {
		this.numProcess = numProcess;
	}
	public void setNumReplica(int numReplica) {
		this.numReplica = numReplica;
	}
	public int getNumProcess() {
		return numProcess;
	}
	public int getNumReplica() {
		return numReplica;
	}

	public int size() {
		return table.size();
	}

	public URI getDataURI(int index) {
		return table.elementAt(index).getDataURI();
	}

	public String getCmdHost(int index) {
		return table.elementAt(index).getCmdURI().getHost();
	}

	public int getCmdPort(int index) {
		TableInfo tmp = table.elementAt(index);
		return table.elementAt(index).getCmdURI().getPort();
	}

	public URI getCmdURI(int index) {
		return table.elementAt(index).getCmdURI();
	}

	public URI getCtrlURI(int index) {
		return table.elementAt(index).getCtrlURI();
	}

	public String getCtrlHost(int index) {
		return table.elementAt(index).getCtrlURI().getHost();
	}

	public int getCtrlPort(int index) {
		return table.elementAt(index).getCtrlURI().getPort();
	}

	public String getDataHost(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getDataURI().getHost();
	}

	public int getDataPort(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getDataURI().getPort();
	}

	public int getFDPort(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getFDPort();
	}

	public int getRank(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getRank();
	}

	public boolean isAlive(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isAlive();
	}

	public boolean isTerminated(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isTerminated();
	}

	/*
	public boolean isVisible(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isVisible();
	}
	*/

	public void setAlive(int index, boolean alive) {
		TableInfo tmp = table.elementAt(index);
		tmp.setAlive(alive);
	}

	public void setTerminated(int index, boolean terminated) {
		TableInfo tmp = table.elementAt(index);
		tmp.setTerminated(terminated);
	}

	/*
	public void setWorldRank(int index, int worldRank) {
		table.elementAt(index).setWorldRank(worldRank);
	}

	public void setVisible(int index, boolean visible) {
		TableInfo tmp = table.elementAt(index);
		tmp.setVisible(visible);
	}
	*/


	// Return only alive process
	public URI[] getURIs() {
		int size = size();
		URI[] result = new URI[size];
		TableInfo tmp;
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			try {
				result[i] = new URI(tmp.getCmdURI().toString());
			} catch (Exception e) {}
		}

		return result;
	}

	public URI[] getFDURIs() {
		int size = size();
		URI[] result = new URI[size];
		TableInfo tmp;
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			try {
				result[i] = new URI(tmp.getFDURI().toString());
			} catch (Exception e) {}
		}

		return result;
	}

	public Vector<Integer> getRankInListByRank(int rank) {
		Vector<Integer> result = new Vector<Integer>();
		TableInfo tmp;
		int size = size();

		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			if(tmp.getRank() == rank) {
				if(tmp.isAlive()) {
					Integer element = new Integer(i);
					result.addElement(element);
				}
			}
		}

		return result;
	}

	public int getRankInReplica(URI uri, int rankInList) {
		int size = size();	
		int position = 0;
		//System.out.println("[GetRankInReplica]" + uri.getHost() + ":" uri.getPort() + ",MPI rank" + rank);
		TableInfo tmp = table.elementAt(rankInList);
		int rank = tmp.getRank();
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			if(tmp.getRank() == rank) {
				if(tmp.getDataURI().toString().equals(uri.toString())) {
					return position;
				}
				position++;
			}
		}
		return -1;
	}

	public Vector<URI> getURIByRank(int rank) {
		Vector<URI> result = new Vector<URI>();
		TableInfo tmp;
		int size = size();
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			if(tmp.getRank() == rank) {
				if(tmp.isAlive()) {
					result.addElement(tmp.getCmdURI());
				}
			}
		}
		return result;
	}

	public class TableInfo implements Serializable {
		private static final long serialVersionUID = 1000006L;
		int rank;
		URI cmdURI;
		URI ctrlURI;
		URI dataURI;
		boolean alive;
		int fdPort;
		boolean terminated;
		//boolean visible;

		public TableInfo(int rank, URI cmdURI, URI ctrlURI, URI dataURI, boolean alive, int fdPort) {
			this.rank 	= rank;
			this.cmdURI	= cmdURI;
			this.ctrlURI	= ctrlURI;
			this.dataURI    = dataURI;
			this.alive	= alive;
			this.terminated = false;
			this.fdPort	= fdPort;
			//this.visible	= true;
		}

		public void setAlive(boolean alive) {
			this.alive 	= alive;
		}

		public void setTerminated(boolean terminated) {
			this.terminated = terminated;
		}

		public void setFDPort(int fdPort) {
			this.fdPort = fdPort;
		}

		public int getFDPort() {
			return fdPort;
		}

		public URI getFDURI() {
			URI result = null;
			try {
				result = new URI("tcp://"+cmdURI.getHost()+":"+fdPort);
			} catch (Exception e) {
				e.printStackTrace();
			}
			return result;
		}

		/*
		public void setVisible(boolean visible) {
			this.visible = visible;
		}
		*/

		public boolean isAlive() {
			return alive;
		}

		public boolean isTerminated() {
			return terminated;
		}

		public URI getCmdURI() {
			return cmdURI;
		}

		public URI getDataURI() {
			return dataURI;
		}

		public URI getCtrlURI() {
			return ctrlURI;
		}

		public int getRank() {
			return rank;
		}

		/*
		public boolean isVisible() {
			return visible;
		}
		*/
	}
	
}
