package p2pmpi.common;

import java.io.*;

public class JobInfo implements Serializable {
	private static final long serialVersionUID = 3001000L;
	String hashID;
	int status;
	long timeStamp;
	long reservePeriod;

	public static final int JOB_RESERVED = 0;
	public static final int JOB_STARTING = 1;
	public static final int JOB_RUNNING  = 2;

	public JobInfo(String hashID, int status, long reservePeriod) {
		this.hashID = hashID;
		this.status = status;
		this.reservePeriod = reservePeriod;
		timeStamp = System.currentTimeMillis();
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getHashID() {
		return hashID;
	}

	public int getStatus() {
		return status;
	}

	public long getTimeStamp() {
		return timeStamp;
	}

	public long getReservePeriod() {
		return reservePeriod;
	}

	//return time since reserved in seconds
	/*
	public long getUpTime() {
		return (System.currentTimeMillis() - timeStamp)/1000;
	}
	*/

	public boolean isOverReservePeriod() {
		if((System.currentTimeMillis() - timeStamp) > + reservePeriod)
			return true;
		else
			return false;
	}
}
