package p2pmpi.common;

import java.io.*;
import java.util.*;
import org.apache.log4j.*;


public class GenericConfigFile {
        Properties props;

	  /**
         * Constructor 1
         **/
        public GenericConfigFile() {
                props = new Properties();
	  }
	  /**
         * Constructor 2
         **/
        public GenericConfigFile(String fileName) {
                props = new Properties();
                try {
                        InputStream is = new FileInputStream(fileName);
                        props.load(is);
                        is.close();
                } catch (Exception e) {
                        e.printStackTrace();
                }
        }

        /**
         * Initialize config filename (e.g. used after constructor 1)
         **/
	  public void setFileName( String fileName ) {
                try {
                        InputStream is = new FileInputStream(fileName);
                        props.load(is);
                        is.close();
                } catch (Exception e) {
                        e.printStackTrace();
                }
	 }

	 /**
	   * Get the string associated with the property.
	   **/
        public String getProperty(String key) {
                return props.getProperty(key);
 	  }
	 /**
	   * Get the string associated with the property, and log an error if any.
	   **/
        public String getProperty(String key, Logger log) {
		     String strVal = getProperty( key );
                 if ( strVal == null && log != null ) {
                   log.error("[Error] property "+key+" badly defined or undefined in configuration file.");
                 }
                 return( strVal );
        }

        public Properties getProperties() {
                return props;
        }
}
