package p2pmpi.visu;

import java.net.*;
import java.util.*;
import java.io.*;

import p2pmpi.common.*;
import p2pmpi.tools.*;
import p2pmpi.mpd.*;

/**
 * @author ghazi,genaud
 */

public class Visu extends Thread {

	  // The object that will do the work with the GUI ....  
	  Visu_Param  v;
	  private boolean textMode=false;
	  private int refreshRate = 30;   // default: every 30s

	  // options: always 4 arguments: short name,long name, parameter, explaination 
	  private static String options[]={
		    "-h","--help",    null, "Display this help message.",
		    "-c","--console", "r",  "Run in console mode. Refresh every r seconds."
	  };
	  int id = 0;

	  /**
	   * usage.
	   **/

	  private static void usage() {
		    int i;
		    System.out.println("usage: runVisu [OPTION...]");  
		    for(i=0;i<options.length;i+=4) {
				System.out.print(options[i]+"| "+options[i+1]+"\t");
				if (options[i+2]!=null) 
					  System.out.print(options[i+2]);
				System.out.println("\t"+options[i+3]);  
		    }
	  }

	  /**
	   * parse command line arguments.
	   *	 
	   * @param args the command line arguments
	   * @param optionNum the option (as described in options array) to detect in args
	   * @return null when option optionNum is not in the command line arguments 
	   *         If the option exists among arguments 
	   *         return either a value if option requires a parameter value
	   *         or an empty string if option does not require a value
	   **/
	  private static String parseArgs(String [] args,int optionNum) {
		    int i,
			  indx  = optionNum*4;  // indx in option array, based on 4 item / option

		    for (i=0;i<args.length;i++) {
				// match short or long option name ?
				if (args[i].equals(options[indx]) || args[i].equals(options[indx+1])) {
					  // option supposed to have a parameter value ?
					  if (options[indx+2] != null) {
						    if (args.length >= i+2 )
								return (args[i+1]); // Next arg is supposed to be the parameter
						    else {
								System.out.println("command line parse error: "+
										    options[indx]+" or "+ options[indx+1]+" requires a parameter.");
								System.exit(1);
						    }
					  }
					  else {
						    return (new String("")); // an empty string means option was selected,
						    // but no value.
					  }
				}
		    }
		    return (null);
	  }
	  /**
	   * Constructor 
	   **/
	  public Visu( String[] args ) {

		    // command line args parsing
		    if ( args.length > 0 ) {
				String ret=null;
				// help option is in position 0
				if ( (ret=parseArgs(args,0)) != null ) {
					  usage();
					  System.exit(0);
				}	   

				String valRefresh= null;
				// console mode option is in position 1
				valRefresh = parseArgs(args,1);
				if (valRefresh != null) {
					  textMode=true;
					  if(!valRefresh.equals(""))
						    refreshRate = Integer.parseInt(valRefresh);
					  System.out.println("Console mode (refresh every "+refreshRate+" seconds)");
				}
				else {
					  System.out.println("Bad command line arguments.");
					  usage();
					  System.exit(1);
				}
		    }
	  }

	  /**
	   * Thread doing the work ... 
	   * @author: genaud
	   **/ 
	  public void run() {
		    
		    v = new Visu_Param( this, textMode );
	  }


	/**
  	 * Main
  	 **/

	public static void main(String[] args) {

	  	// initialiez P2P-MPI platform	

		Visu mpiDaemon = new Visu( args );
		mpiDaemon.start();
	}
}
