import p2pmpi.mpi.*;
import java.lang.Math;

public class FDTest {
	public static void main(String[] args) {
		int BUF_SIZE = 1000000;
		int numloop = 0;

		MPI.Init(args);
		int myRank = MPI.COMM_WORLD.Rank();
		int size   = MPI.COMM_WORLD.Size();

		long[] sendBuf = new long[BUF_SIZE];
		long[] recvBuf = new long[BUF_SIZE];

		while(true) {
			numloop++;
			if(myRank == 0) {
				//Assign new value for sendBuf
				for(int i = 0; i < BUF_SIZE; i++) {
					sendBuf[i] = numloop;
				}

				System.out.println("================================================");
				System.out.println("Send/Recv Loop: " + numloop);
				System.out.println("================================================");

				MPI.COMM_WORLD.Send(sendBuf, 0, BUF_SIZE, MPI.LONG, 1, 2);
				MPI.COMM_WORLD.Recv(recvBuf, 0, BUF_SIZE, MPI.LONG, 1, 2);

				/////////// Verification the result of recvBuf with sendBuf ///////////
				System.out.println("Recv[0] = " + recvBuf[0]);
				boolean passed = true;
				for(int i = 0; i < BUF_SIZE; i++) {
					if(recvBuf[i] != numloop) {
						passed = false;
						break;
					}
				} 
				if(passed) {
					System.out.println("The verification is successful");
				} else {
					System.out.println("The verification is FAILED!!");
				}
				System.out.println("================================================\n");
				////////////////////////////////////////////////////////////////////////

			} else {
				MPI.COMM_WORLD.Recv(recvBuf, 0, BUF_SIZE, MPI.LONG, 0, 2);
				MPI.COMM_WORLD.Send(recvBuf, 0, BUF_SIZE, MPI.LONG, 0, 2);
			}

			/*
			try {
				Thread.sleep(5000); //Sleep 5 seconds
			} catch (Exception e) {
				e.printStackTrace();
			}
			*/
		}

		//MPI.Finalize();	
	}
}
