package p2pmpi.p2p;
import p2pmpi.p2p.message.*;

import p2pmpi.common.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class StopSuperNode {
	public static void main(String[] args) {
		//read config file for internal RDV port
		File configFile = new File(System.getProperty("P2PMPI_HOME"), "P2P-RDV.conf");
		GenericConfigFile conf = new GenericConfigFile(configFile.toString());
		int internalPort = Integer.parseInt(conf.getProperty("InternalPort"));
		try {
			QuitMessage quitMsg = new QuitMessage();
			Socket s = new Socket("127.0.0.1", internalPort);
			OutputStream out = s.getOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			System.out.println("Supernode shutdown ... done.");
		} catch (Exception e) {
			System.out.println("No supernode process is running at port:" + internalPort);
			//e.printStackTrace();
		}
	}
}
