package p2pmpi.mpi.dev;

import java.nio.*;
import java.io.*;
import java.util.*;
import java.nio.channels.Selector;

public class SelectorFactory {
	Selector[] selectors;
	int numSelector;
	int maxSelector;

	public SelectorFactory(int maxSelector) {
		numSelector = 0;	
		this.maxSelector = maxSelector;
		selectors = new Selector[maxSelector];
		try {
			for(int i = 0; i < maxSelector; i++) {
				selectors[i] = Selector.open();
			}
		} catch (Exception e) { e.printStackTrace();}
	}

	public Selector getSelector() {
		return selectors[(numSelector++)%maxSelector];
	}

	public void returnSelector(Selector selector) {
		try {
			selector.selectNow();
		} catch(Exception e) {e.printStackTrace();}
		//ReturnSelector retSelector = new ReturnSelector(selector);
		//retSelector.start();
	}


	public class ReturnSelector extends Thread {
		Selector selector;

		public ReturnSelector(Selector selector) {
			this.selector = selector;
		}	
		public void run() {
			try {
				selector.select(1);
			} catch(Exception e) { e.printStackTrace();}
		}
	}
}
