package p2pmpi.mpi.dev;

import p2pmpi.mpi.*;
import p2pmpi.message.*;
import p2pmpi.common.*;
import java.net.*;
import java.io.*;
import java.util.*;

/**
 * Asynchronous message handler for handling all received messages
 */
public class MessageHandler implements Runnable 
{
	private String key;
	//private int port;				// MPI Port
	private boolean ready;				// Ready Flag
	private ServerSocket servSocket = null;
	private RankTable rankTable;			// Communication Table
	private int myRank;				// Rank in MPI
	private int myRankInList;			// Rank in Com Table
	private int commSize;				// Number of MPI Rank


	//private int myMaster;		// Master Rank of this replica
	//private boolean master;		// True if this process is a master of replica

	private int t_gossip; 		// time for each gossip
	private String gossipProtocol;	// gossip protocol
	private int t_margin;		// margin time because starting counting heartbeat
	private int t_diff;		// different time of rank 0 and this rank receive rank table
	private int t_hang;

	private volatile boolean shutdown = false;

	private boolean rankZero;
	private Device dev;

	//TO DELETE FDPORT, MPDPort from argument of constructor
	/**
	 * Internal use
	 */
	public MessageHandler(Device dev, ServerSocket servSocket, int commSize, RankTable rankTable, String key, int mpdPort, int fdPort) {
		this.dev 	= dev;
		this.commSize	= commSize;
		this.key	= key;
		this.rankTable	= rankTable;
		this.ready 	= false;
		this.rankZero	= true;

		shutdown = false;

		this.servSocket = servSocket;
		try {
			this.servSocket.setSoTimeout(0);
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}

	/**
	 * Internal use
	 */
	public MessageHandler(Device dev, ServerSocket servSocket, String key, int mpdPort, int fdPort) {
		this.dev	= dev;
		this.key	= key;
		this.ready 	= false;
		shutdown = false;
		this.rankZero	= false;

		this.servSocket = servSocket;
		try  {
			this.servSocket.setSoTimeout(0);
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}

	public void shutdown() {
		shutdown = true;
		try {
			if(servSocket != null) {
				servSocket.close();
			}
		} catch (Exception e) {}
	}

	/*
	public void setSendBackupAndLog(Vector<SendBufferInformation> backupBuffer, MessageIDLog sendLog) {
		this.backupBuffer = backupBuffer;
		this.sendLog	  = sendLog;
	}
	*/

	public void setRankTable(RankTable rankTable) {
		this.rankTable = rankTable;
	}

	public void setTHang(int t_hang) {
		this.t_hang = t_hang;
	}

	public int getTHang() {
		return t_hang;
	}

	public RankTable getRankTable() {
		return rankTable;
	}

	public void run() {
		Socket socket = null;
		InputStream in = null;
		ObjectInputStream ois = null;
		Object msg = null;
		RecvBufferInformation buff = null;
		String mid;

		//Set Timeout to wait for ranktable from rank 0
		if(!rankZero) {
			try {
				servSocket.setSoTimeout(600000); //timeout 10 minutes
			} catch (Exception e) {
				//e.printStackTrace();
			}
		}

		//servSocket.setSoTimeout(600000);
		while(!shutdown) {
			try {
				socket = servSocket.accept();
			} catch (SocketTimeoutException soe) {
				//No syn message from peers
				//System.out.println(" Oooh ... tell me what others are doing, rank 0 !");
				//soe.printStackTrace();
				System.exit(1);
			} catch (IOException e) {
				continue;
			}

			try {
				in = socket.getInputStream();
				ois = new ObjectInputStream(in);
				msg = ois.readObject();
			} catch (Exception e) {
				try {
					ois.close();
					in.close();
					socket.close();
				} catch (Exception ee) { 
					//ee.printStackTrace();
				}
				//e.printStackTrace();
				continue;
			}

			if(msg instanceof MPIMessage) {
				MPIMessage mpiMsg = (MPIMessage)msg;
				switch(mpiMsg.getCmd()) {
					case MessageCmd.MPI_SYN2 :
						ready = true;
						myRank = mpiMsg.getRank();
						myRankInList = mpiMsg.getRankInList();
						commSize = mpiMsg.getSize();
						setRankTable(mpiMsg.getCommTable());
						t_gossip = mpiMsg.getTGossip();
						t_margin = mpiMsg.getTMargin();
						t_hang   = mpiMsg.getTHang();
						t_diff   = mpiMsg.getTDiff();
						gossipProtocol = mpiMsg.getGossipProtocol();
						try {
							servSocket.setSoTimeout(0);
						} catch (Exception e) {
							//e.printStackTrace();
						}
					break;
				}

			} else if(msg instanceof NotifyMessage) {
				NotifyMessage noMsg = (NotifyMessage)msg;
				int deadNodeRank = noMsg.getRankInList();
				//System.out.println("[MessageHandler]: got notify dead node = " + deadNodeRank);
				dev.doFailureRepair(deadNodeRank);


			} else if (msg instanceof IsAliveMessage) {
				IsAliveMessage isAliveMsg = (IsAliveMessage)msg;
				Socket s = null;
				OutputStream out = null;
				ObjectOutputStream oos = null;

				if(key.equals(isAliveMsg.getKey())) {
					//Return my key	
					AliveMessage aliveMsg = new AliveMessage(key);
					try {
						out = socket.getOutputStream();
						oos = new ObjectOutputStream(out);
						oos.writeObject(aliveMsg);
						oos.close();
						out.close();
					} catch (Exception e) {}
				} else {
					NoAliveMessage noaliveMsg = new NoAliveMessage();
					try {
						out = socket.getOutputStream();
						oos = new ObjectOutputStream(out);
						oos.writeObject(noaliveMsg);
						oos.close();
						out.close();
					} catch (Exception e) {}
				}

			} else if (msg instanceof RequestQuitMessage) {
				//just exit
				System.exit(0);
			} else if (msg instanceof OutputMessage) {
				OutputMessage outputMsg = (OutputMessage)msg;
				System.out.println(outputMsg.getOutput());	
			} else {
				System.err.println("** [Warning] received unknow type of message.");
			}

			try {
				ois.close();
				in.close();
				socket.close();
			} catch (Exception e) {
				System.err.println("** [Error] cannot close communication, maybe a network problem.");
			}
		}
	}
	
	public boolean isReady() {
		return ready;
	}

	public void setTGossip(int t_gossip) {
		this.t_gossip = t_gossip;
	}

	public void setTMargin(int t_margin) {
		this.t_margin = t_margin;
	}

	public int getTDiff() {
		return t_diff;
	}

	public int getTGossip() {
		return t_gossip;
	}

	public void setGossipProtocol(String protocol) {
		gossipProtocol = new String(protocol);
	}

	public String getGossipProtocol() {
		return gossipProtocol;
	}

	public int getTMargin() {
		return t_margin;
	}

	public int getRank() {
		return myRank;
	}

	public int getRankInList() {
		return myRankInList;
	}

	public int getCommSize() {
		return commSize;
	}
	public void stop() {
		try {
			//System.out.println("CLOSE  ServSocket");
			servSocket.close();
		} catch (Exception e) {
			//e.printStackTrace();
		}
	}
}
