package p2pmpi.mpi.dev;

import java.nio.*;

public class BufferFloat extends P2PMPI_Buffer {
	public BufferFloat(int baseSize) {
		super(baseSize);
	}

	public ByteBuffer fillBuffer(ByteBuffer myBuffer, Object buffer, int offset, int count) {
		FloatBuffer fBuffer = myBuffer.asFloatBuffer();
		fBuffer.put((float[])buffer, offset, count);
		myBuffer.position(myBuffer.position() + (count * baseSize));

		return myBuffer;
	}

	public int fillRecvData(Object buffer, int offset, int count, ByteBuffer data, int dataSize) {
		int recvData;
		if((dataSize/baseSize) < count)
			recvData = dataSize/baseSize;
		else
			recvData = count;


		FloatBuffer fBuffer = data.asFloatBuffer();
		fBuffer.get((float[])buffer, offset, recvData);
		data.position(data.position() + (recvData*baseSize));

		return (recvData - offset) * baseSize;
	}

	public Object createArrayBuffer(int count) {
		return new float[count];
	}

}
