/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.TGException;
import java.awt.Color;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import p2pmpi.common.HostEntry;
import p2pmpi.common.ProcessInfo;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.mpd.PeerCache;
import p2pmpi.p2p.message.RegisterMessage;
import p2pmpi.p2p.message.UnregisterMessage;
import p2pmpi.tools.SupernodeHostCacheDisplay;
import p2pmpi.visu.PeerNode;
import p2pmpi.visu.Visu_Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatQuery
extends Thread {
    private static Logger log;
    Visu_Param parent;
    private URI supernode;
    private URI visuproxy;
    private Vector<HostEntry> peerList = null;
    private PeerCache peerDiskCache = null;
    private String peerCachePath = null;
    private String externalIp = null;
    private int listenPort;
    protected boolean connectedToProxy;

    public StatQuery(URI uRI, URI uRI2, String string, String string2, int n, Visu_Param visu_Param) {
        log = Logger.getLogger((String)"VISU");
        this.parent = visu_Param;
        this.peerCachePath = string;
        this.peerDiskCache = new PeerCache(string);
        this.supernode = uRI;
        this.visuproxy = uRI2;
        this.externalIp = string2;
        this.listenPort = n;
        if (n == -1 || uRI2 == null) {
            this.connectedToProxy = false;
            log.debug((Object)"@ StatQuery :: StatQuery() -> listenPort=-1 or visuproxy==null");
            System.out.println("Cannot connect to a VisuProxy. I will query SuperNode directly.");
        } else {
            this.connectedToProxy = this.register();
            log.debug((Object)("@ StatQuery :: StatQuery() -> connectedToProxy == " + this.connectedToProxy));
        }
    }

    public boolean isConnectedToVisuProxy() {
        return this.connectedToProxy;
    }

    public int updatePeerList() {
        if (!this.connectedToProxy) {
            log.debug((Object)("[visu client] contacting Supernode " + this.supernode.getHost() + ":" + this.supernode.getPort()));
            SupernodeHostCacheDisplay supernodeHostCacheDisplay = new SupernodeHostCacheDisplay();
            this.peerList = SupernodeHostCacheDisplay.query(this.supernode.getHost(), this.supernode.getPort());
            if (this.peerList == null) {
                log.error((Object)("[visu client] could not contact Supernode " + this.supernode.toString() + " while not registered to a VisuProxy."));
                return -1;
            }
            log.info((Object)("[visu client] Supernode returns " + this.peerList.size() + " connected hosts."));
            return this.peerList.size();
        }
        return 0;
    }

    public void setPeerList(Vector<HostEntry> vector) {
        this.peerList = vector;
    }

    public void writeCache() {
        log.debug((Object)("@ StatQuery::writeCache(\"" + this.peerCachePath + "\")"));
        this.peerDiskCache.saveDocument(this.peerCachePath);
    }

    public String getMyIp() {
        String string = null;
        if (this.externalIp == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                log.error((Object)"Could not determine my own IP address ! Exiting.");
                System.exit(1);
            }
            return string;
        }
        return this.externalIp;
    }

    public boolean register() {
        boolean bl = false;
        HostEntry hostEntry = new HostEntry(this.getMyIp(), 0, 0, 0, 0, 0);
        RegisterMessage registerMessage = new RegisterMessage(hostEntry, this.listenPort);
        try {
            Socket socket = new Socket(this.visuproxy.getHost(), this.visuproxy.getPort());
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(registerMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
            System.out.println("Registering to VisuProxy: " + this.visuproxy.toString());
            bl = true;
        }
        catch (Exception exception) {
            log.error((Object)("Could not connect to Visu Proxy " + this.visuproxy.toString()));
        }
        return bl;
    }

    public boolean unregister() {
        boolean bl = false;
        if (!this.connectedToProxy) {
            return true;
        }
        HostEntry hostEntry = new HostEntry(this.getMyIp(), 0, 0, 0, 0, 0);
        UnregisterMessage unregisterMessage = new UnregisterMessage(hostEntry);
        try {
            Socket socket = new Socket(this.visuproxy.getHost(), this.visuproxy.getPort());
            OutputStream outputStream = socket.getOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(unregisterMessage);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
            log.debug((Object)("Un-registering to visu proxy " + this.visuproxy.toString()));
            bl = true;
        }
        catch (Exception exception) {
            log.error((Object)("@ could not connect to visu proxy " + this.visuproxy.toString() + " : " + exception.getCause()));
        }
        return bl;
    }

    private String[] whois(String string) {
        String[] stringArray = new String[2];
        stringArray[0] = string;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string2 = inetAddress.getCanonicalHostName();
            if (string2.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                stringArray[1] = "unregistered";
            } else {
                int n = string2.indexOf(".");
                if (n > 0) {
                    stringArray[0] = string2.substring(0, n);
                    stringArray[1] = string2.substring(n + 1);
                } else {
                    stringArray[0] = string2;
                    stringArray[1] = "localdomain";
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            stringArray[1] = "Unresolved";
        }
        return stringArray;
    }

    private StatInfoMessage fillStatInfoMessageFromMpdQuery(String string, int n) {
        StatInfoMessage statInfoMessage = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        ObjectOutputStream objectOutputStream = null;
        Socket socket = null;
        ObjectInputStream objectInputStream = null;
        try {
            StatQueryMessage statQueryMessage = new StatQueryMessage();
            log.debug((Object)("@ StatQuery::fillStatInfoMessageFromMpdQuery(" + string + "," + n + ")"));
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, 5000);
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(statQueryMessage);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(inputStream);
            statInfoMessage = (StatInfoMessage)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return statInfoMessage;
    }

    private StatInfoMessage fillStatInfoMessageFromPeerCache(String string, int n) {
        StatInfoMessage statInfoMessage = null;
        String string2 = new String(string + ":" + n);
        statInfoMessage = new StatInfoMessage(string, n, this.peerDiskCache.getMpdVer(string2), this.peerDiskCache.getOsName(string2), this.peerDiskCache.getArch(string2), this.peerDiskCache.getCpuName(string2), this.peerDiskCache.getCpuFreq(string2), this.peerDiskCache.getMem(string2));
        return statInfoMessage;
    }

    private boolean addCache(StatInfoMessage statInfoMessage) {
        boolean bl = true;
        log.debug((Object)"@ StatQuery::addCache() --> starts.");
        String string = new String(statInfoMessage.getIp() + ":" + statInfoMessage.getMpdPort());
        bl &= this.peerDiskCache.setMpdVer(string, statInfoMessage.getMpdVer());
        bl &= this.peerDiskCache.setOsName(string, statInfoMessage.getOsName());
        bl &= this.peerDiskCache.setArch(string, statInfoMessage.getArch());
        bl &= this.peerDiskCache.setCpuName(string, statInfoMessage.getCpuName());
        bl &= this.peerDiskCache.setCpuFreq(string, statInfoMessage.getCpuFreq());
        return bl &= this.peerDiskCache.setMem(string, statInfoMessage.getMem());
    }

    @Override
    public void run() {
        this.currentThread().setName("StatQuery thrd");
        this.query(true);
    }

    public boolean query(boolean bl) {
        StatInfoMessage statInfoMessage = null;
        if (this.peerList == null) {
            log.debug((Object)"@ StatQuery::query() --> query starts and return immediately (peerList==null)");
            return false;
        }
        log.debug((Object)("@ StatQuery::query() --> query starts useCache=" + bl));
        Iterator<HostEntry> iterator = this.peerList.iterator();
        while (iterator.hasNext()) {
            HostEntry hostEntry = iterator.next();
            String string = hostEntry.getIp();
            int n = hostEntry.getMpdPort();
            log.debug((Object)("@ StatQuery::query() --> iter element " + string));
            if (bl && this.peerDiskCache.hasId(string + ":" + n)) {
                log.debug((Object)("@ StatQuery::query() -> peerDiskCache.hasId( " + string + ":" + n + ") == true"));
                statInfoMessage = this.fillStatInfoMessageFromPeerCache(string, n);
            } else {
                this.peerDiskCache.remove(string + ":" + n);
                log.debug((Object)("@ StatQuery::query() --> peerDiskCache.hasId( " + string + ":" + n + ") == false"));
                statInfoMessage = this.fillStatInfoMessageFromMpdQuery(string, n);
                if (statInfoMessage != null) {
                    this.addCache(statInfoMessage);
                }
            }
            if (statInfoMessage != null) {
                String[] stringArray = this.whois(string);
                log.debug((Object)("@ StatQuery::query() --> whois(+" + string + ")=" + stringArray[0] + "." + stringArray[1] + "(os=" + statInfoMessage.getOsName() + ")"));
                Boolean bl2 = false;
                PeerNode peerNode = this.parent.jc2.findNode(string);
                if (peerNode == null) {
                    bl2 = true;
                }
                log.debug((Object)("@ StatQuery::query() -->  node " + string + " creation == " + bl2));
                if (bl2.booleanValue()) {
                    peerNode = new PeerNode(string, stringArray[0], this.parent);
                }
                peerNode.setProperties(stringArray[0], statInfoMessage.getIp(), stringArray[1], statInfoMessage.getCpuName(), statInfoMessage.getCpuFreq(), statInfoMessage.getMem(), statInfoMessage.getOsName(), statInfoMessage.getArch());
                peerNode.setStatus("Available");
                if (bl2.booleanValue()) {
                    this.parent.peers.addElement(peerNode);
                    PeerNode peerNode2 = this.parent.jc2.findNode(stringArray[1]);
                    if (peerNode2 == null) {
                        try {
                            peerNode2 = new PeerNode(stringArray[1], stringArray[1]);
                            peerNode2.setBackColor(Color.WHITE);
                            peerNode2.setType(3);
                            peerNode2.setTextColor(Color.BLACK);
                            this.parent.jc2.addNode(peerNode2);
                        }
                        catch (TGException tGException) {
                            // empty catch block
                        }
                    }
                    peerNode.setType(2);
                    peerNode.setHint("IP: " + string + "\nStatus: Available\nOS: ");
                    peerNode.setBackColor(Color.decode("#4080A0"));
                    try {
                        this.parent.jc2.addNode(peerNode);
                        Edge edge = this.parent.jc2.addEdge(peerNode, peerNode2, 2 * Edge.DEFAULT_LENGTH);
                    }
                    catch (TGException tGException) {
                        // empty catch block
                    }
                }
                int n2 = statInfoMessage.size();
                log.debug((Object)("@ StatQuery::run() --> numProcesses=" + n2));
                boolean bl3 = false;
                for (int i = 0; i < n2; ++i) {
                    ProcessInfo processInfo = statInfoMessage.getInfo(i);
                    if (processInfo.getRank() != 0) continue;
                    bl3 = true;
                }
                if (bl3) {
                    this.parent.infoMsgs.addElement(statInfoMessage);
                }
                this.parent.fillPeers();
            } else {
                log.debug((Object)("@ StatQuery::query() --> could not contact " + string + ":" + n + " . Remove from peerList."));
                iterator.remove();
            }
            if (this.parent.fen != null) {
                log.debug((Object)("@ StartQuery::query() --> graphic refresh() for " + this.parent.fen));
                this.parent.fen.refresh();
            }
            if (this.parent.jdispTable == null) continue;
            this.parent.refreshTables();
        }
        log.debug((Object)"@ StatQuery::query() --> query ends.");
        return true;
    }
}

