/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.io.File;
import java.net.ServerSocket;
import java.net.URI;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Logger;
import p2pmpi.common.P2PMPI_ConfigFile;
import p2pmpi.visu.NetMap;
import p2pmpi.visu.ProxyNotificationListener;
import p2pmpi.visu.StatQuery;
import p2pmpi.visu.Visu_Param;
import p2pmpi.visu.taskTableModel;

public class RefreshDisplay
implements Runnable {
    private static Logger log;
    Visu_Param window;
    private URI superNode;
    private boolean clearCacheStatus;
    private StatQuery MPDReadyQuery = null;
    private Thread proxyNotificationListener = null;
    private int listenPort;
    private ServerSocket listenServerSocket;

    public RefreshDisplay(Visu_Param visu_Param) {
        log = Logger.getLogger((String)"VISU");
        log.debug((Object)"@ RefreshDisplay :: RefreshDisplay()");
        File file = new File(System.getProperty("P2PMPI_HOME"), "P2P-MPI.conf");
        P2PMPI_ConfigFile p2PMPI_ConfigFile = new P2PMPI_ConfigFile(file.toString());
        URI uRI = p2PMPI_ConfigFile.getSuperNode();
        URI uRI2 = p2PMPI_ConfigFile.getVisuProxy();
        String string = p2PMPI_ConfigFile.getPeerCacheFile();
        String string2 = p2PMPI_ConfigFile.getExternalIP();
        int n = p2PMPI_ConfigFile.getMinPort();
        int n2 = p2PMPI_ConfigFile.getMaxPort();
        this.window = visu_Param;
        this.listenServerSocket = this.getServerSocket(n, n2);
        if (this.listenServerSocket != null) {
            this.listenPort = this.listenServerSocket.getLocalPort();
            this.MPDReadyQuery = new StatQuery(uRI, uRI2, string, string2, this.listenPort, visu_Param);
            ProxyNotificationListener proxyNotificationListener = new ProxyNotificationListener(this.MPDReadyQuery, this.listenServerSocket);
            log.debug((Object)"@ RefreshDisplay :: RefreshDisplay() --> starting proxyNotificationListener thread ... ");
            proxyNotificationListener.start();
        } else {
            this.MPDReadyQuery = new StatQuery(uRI, uRI2, string, string2, -1, visu_Param);
        }
    }

    public void quit() {
        try {
            this.listenServerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.MPDReadyQuery.writeCache();
        this.MPDReadyQuery.unregister();
    }

    public void setClearCache(boolean bl) {
        this.clearCacheStatus = bl;
    }

    private ServerSocket getServerSocket(int n, int n2) {
        ServerSocket serverSocket = null;
        if (n2 - n > 0) {
            int n3;
            int n4;
            Random random = new Random();
            for (n4 = n3 = random.nextInt(n2 - n) + n; n4 <= n2; ++n4) {
                try {
                    serverSocket = new ServerSocket(n4);
                    break;
                }
                catch (Exception exception) {
                    serverSocket = null;
                    continue;
                }
            }
            if (serverSocket == null) {
                for (n4 = n; n4 <= n2; ++n4) {
                    try {
                        serverSocket = new ServerSocket(n4);
                        break;
                    }
                    catch (Exception exception) {
                        serverSocket = null;
                        continue;
                    }
                }
                if (serverSocket == null) {
                    System.err.println("** [Error] No allowed ports are available in [" + n + "--" + n2 + "]");
                }
            }
        } else {
            String string = new String("[Error] Visu client: port range [MIN_PORT - MAX_PORT] in configuration is invalid.");
            log.error((Object)string);
            System.err.println(string);
        }
        return serverSocket;
    }

    public synchronized void monitorReloadOrRefresh(long l) {
        log.debug((Object)("@ RefreshDisplay :: monitorReloadOrRefresh() --> wait(" + l + ") \n"));
        if (l == 0L) {
            this.notify();
        } else {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = 0;
        while (true) {
            block10: {
                block9: {
                    if (!this.MPDReadyQuery.query(this.clearCacheStatus == false)) break block9;
                    RefreshDisplay.log.debug((Object)("@ RefreshDisplay :: run() --> window.peers.size()=" + this.window.peers.size()));
                    ((taskTableModel)this.window.jtaskTable.getModel()).clear();
                    for (var3_3 = 0; var3_3 < this.window.peers.size(); ++var3_3) {
                        this.window.peers.get(var3_3).setStatus("Scanning...");
                        this.window.peers.get((int)var3_3).Tasks.clear();
                    }
                    this.window.infoMsgs.removeAllElements();
                    if (this.window.jc2 == null) {
                        this.window.jc2 = new NetMap(this.window);
                    }
                    this.window.jc2.clearAllComboTask();
                    this.window.jc2.addComboTask("Disponibility");
                    RefreshDisplay.log.debug((Object)("@ RefreshDisplay::run() --> set scan result timestamp " + new Date()));
                    this.window.jLabel6.setText("Scan results at " + new Date());
                    if (this.window.fen != null) {
                        this.window.fen.refresh();
                        RefreshDisplay.log.debug((Object)"@ RefreshDisplay::run() --> window.fen.refresh()");
                    }
                    if (!this.window.textMode) ** GOTO lbl-1000
                    if (Visu_Param.refreshRate > 0) {
                        var1_1 = Visu_Param.refreshRate * 1000;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var1_1 = Integer.parseInt(this.window.refresh.getText()) * 1000;
                        RefreshDisplay.log.debug((Object)("@ RefreshDisplay::run() --> refresh.getText()=" + var1_1));
                    }
                    if (this.window.IsLogging) {
                        this.window.writeLog();
                    }
                    RefreshDisplay.log.debug((Object)("@ RefreshDisplay :: run() --> wait(" + var1_1 + ")"));
                    this.monitorReloadOrRefresh(var1_1);
                    break block10;
                }
                this.monitorReloadOrRefresh(var1_1);
                RefreshDisplay.log.debug((Object)"@ RefreshDisplay :: run() --> peerList is empty.");
            }
            RefreshDisplay.log.debug((Object)"@ RefreshDisplay :: run() -> MPDReadyQuery.updatePeerList( ) ");
            var2_2 = this.MPDReadyQuery.updatePeerList();
            if (var2_2 != -1) continue;
            var3_4 = "[visu client] unable to get information about connected peers. Exiting.";
            RefreshDisplay.log.error((Object)var3_4);
            System.err.println(var3_4);
            try {
                this.listenServerSocket.close();
            }
            catch (Exception var4_5) {
                // empty catch block
            }
            System.exit(1);
        }
    }
}

