/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import p2pmpi.mpi.dev.BufferBoolean;
import p2pmpi.mpi.dev.BufferByte;
import p2pmpi.mpi.dev.BufferChar;
import p2pmpi.mpi.dev.BufferDouble;
import p2pmpi.mpi.dev.BufferFloat;
import p2pmpi.mpi.dev.BufferInt;
import p2pmpi.mpi.dev.BufferLong;
import p2pmpi.mpi.dev.BufferNull;
import p2pmpi.mpi.dev.BufferObject;
import p2pmpi.mpi.dev.BufferShort;
import p2pmpi.mpi.dev.BufferString;

public abstract class P2PMPI_Buffer {
    public static int HEADER_SIZE = 24;
    protected int baseSize;
    short commID;
    int src;
    int dst;
    int tag;
    int numsend;

    public P2PMPI_Buffer(int n) {
        this.baseSize = n;
    }

    public static P2PMPI_Buffer createBuffer(int n, int n2) {
        switch (n) {
            case 1: {
                return new BufferByte(n2);
            }
            case 2: {
                return new BufferChar(n2);
            }
            case 3: {
                return new BufferShort(n2);
            }
            case 5: {
                return new BufferInt(n2);
            }
            case 8: {
                return new BufferDouble(n2);
            }
            case 4: {
                return new BufferBoolean(n2);
            }
            case 7: {
                return new BufferFloat(n2);
            }
            case 6: {
                return new BufferLong(n2);
            }
            case 11: {
                return new BufferObject(n2);
            }
            case 10: {
                return new BufferString(n2);
            }
            case 0: {
                return new BufferNull(n2);
            }
        }
        return new BufferByte(n2);
    }

    public abstract Object createArrayBuffer(int var1);

    public abstract ByteBuffer fillBuffer(ByteBuffer var1, Object var2, int var3, int var4);

    public abstract int fillRecvData(Object var1, int var2, int var3, ByteBuffer var4, int var5);

    public void fillHeader(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)13);
        byteBuffer.put((byte)2);
        byteBuffer.putShort(this.commID);
        byteBuffer.putInt(this.src);
        byteBuffer.putInt(this.dst);
        byteBuffer.putInt(this.tag);
        byteBuffer.putInt(this.numsend);
    }

    public synchronized ByteBuffer getByteBuffer(Object object, int n, int n2, short s, int n3, int n4, int n5, int n6) {
        this.commID = s;
        this.src = n3;
        this.dst = n4;
        this.tag = n5;
        this.numsend = n6;
        int n7 = n2 * this.baseSize;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(HEADER_SIZE + n7);
        this.fillHeader(byteBuffer);
        byteBuffer.putInt(n7);
        byteBuffer = this.fillBuffer(byteBuffer, object, n, n2);
        byteBuffer.flip();
        return byteBuffer;
    }
}

