/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import p2pmpi.common.MapRankTable;
import p2pmpi.common.RankTable;
import p2pmpi.common.Tag;
import p2pmpi.message.AppUnregisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.MessageHandler;
import p2pmpi.mpi.dev.MessageIDLog;
import p2pmpi.mpi.dev.NIORequest;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.RecvBufferInformation;
import p2pmpi.mpi.dev.SendBufferInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Device
implements Runnable {
    protected MessageHandler msgHandle;
    protected int myRank;
    public int numReplica;
    protected int numProc;
    protected int myRankInRep;
    protected int myRankInList;
    protected RankTable rankTable;
    protected boolean terminated;
    protected String myHash;
    protected int fdPort;
    protected int mpdPort;
    protected Vector<RecvBufferInformation> unexpectedQueue = new Vector();
    protected Vector<RecvBufferInformation> expectedQueue = new Vector();
    protected Vector<SendBufferInformation> backupBuffer = new Vector();
    protected MessageIDLog recvLog = new MessageIDLog();
    protected MessageIDLog sendLog = new MessageIDLog();
    protected boolean master;
    protected int myMaster;
    protected Map commMap = new HashMap();
    protected RankTable commWorld;
    protected ExecutorService tpes;
    protected boolean N_POWER2 = false;
    public static int EAGER_SIZE = 131072;

    public boolean isPower2() {
        return this.N_POWER2;
    }

    public abstract boolean isDone();

    public abstract boolean init();

    public abstract int initPort(int var1, int var2, String var3);

    public abstract boolean init(ServerSocket var1, String var2, int var3, int var4);

    public abstract void spawnMessageHandler(ServerSocket var1, int var2, RankTable var3, String var4, int var5, int var6, int var7, int var8, int var9, String var10);

    public abstract void connect(int var1, int var2, int var3, RankTable var4, int var5, int var6);

    public abstract boolean connectToNode(URI var1, int var2, int var3, SocketChannel[][] var4, byte var5);

    public abstract void doFailureRepair(int var1);

    @Override
    public abstract void run();

    public abstract void commit(RankTable var1, int[] var2, short var3, int var4, int var5, int var6, int var7);

    public abstract int ssend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract NIORequest issend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract int send(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract NIORequest isend(RankTable var1, ByteBuffer var2, Vector<Integer> var3, short var4, int var5, int var6, int var7, int var8, int[] var9);

    public abstract IStatus recv(Object var1, int var2, int var3, short var4, int var5, int var6, int var7, int var8, P2PMPI_Buffer var9);

    public abstract NIORequest irecv(Object var1, int var2, int var3, short var4, int var5, int var6, int var7, int var8, P2PMPI_Buffer var9);

    public abstract void finalizeConfirm();

    public abstract void finalize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            for (int i = 0; i < this.rankTable.size(); ++i) {
                if (this.rankTable.isTerminated(i)) continue;
                return false;
            }
            return true;
        }
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meTerminated() {
        RankTable rankTable = this.rankTable;
        synchronized (rankTable) {
            this.rankTable.setTerminated(0, true);
        }
    }

    public void setMaster(boolean bl) {
        this.master = bl;
    }

    public void setMyMaster(int n) {
        this.myMaster = n;
    }

    public boolean isMaster() {
        return this.master;
    }

    public int getRank() {
        return this.msgHandle.getRank();
    }

    public int getCommSize() {
        return this.msgHandle.getCommSize();
    }

    public int getTGossip() {
        return this.msgHandle.getTGossip();
    }

    public int getTMargin() {
        return this.msgHandle.getTMargin();
    }

    public int getTHang() {
        return this.msgHandle.getTHang();
    }

    public String getGossipProtocol() {
        return this.msgHandle.getGossipProtocol();
    }

    public int getTDiff() {
        return this.msgHandle.getTDiff();
    }

    public int getExpectedQueueSize() {
        return this.expectedQueue.size();
    }

    public int getUnexpectedQueueSize() {
        return this.unexpectedQueue.size();
    }

    public void shutdown() {
        this.msgHandle.shutdown();
        this.tpes.shutdownNow();
    }

    public boolean isRankTableReady() {
        return this.msgHandle.isReady();
    }

    public RankTable getRankTable() {
        return this.msgHandle.getRankTable();
    }

    public int getRankInList() {
        return this.msgHandle.getRankInList();
    }

    public boolean isRequestInExpectedQueue(short s, int n, int n2, int n3, int n4) {
        int n5 = this.expectedQueue.size();
        for (int i = 0; i < n5; ++i) {
            boolean bl;
            RecvBufferInformation recvBufferInformation = this.expectedQueue.elementAt(i);
            boolean bl2 = recvBufferInformation.commID() == s && recvBufferInformation.fromRank() == n && recvBufferInformation.toRank() == n2 && recvBufferInformation.numSend() == n4;
            boolean bl3 = recvBufferInformation.getTag() == n3;
            boolean bl4 = n == Tag.MPI_ANYSOURCE;
            boolean bl5 = bl = n3 == Tag.MPI_ANYTAG;
            if (!bl2 && !bl4 || !bl3 && !bl) continue;
            return true;
        }
        return false;
    }

    public NIORequest getRequestFromExpectedQueue(short s, int n, int n2, int n3, int n4, IStatus iStatus) {
        int n5 = this.expectedQueue.size();
        for (int i = 0; i < n5; ++i) {
            boolean bl;
            RecvBufferInformation recvBufferInformation = this.expectedQueue.elementAt(i);
            boolean bl2 = recvBufferInformation.commID() == s && recvBufferInformation.fromRank() == n && recvBufferInformation.toRank() == n2 && recvBufferInformation.numSend() == n4;
            boolean bl3 = recvBufferInformation.getTag() == n3;
            boolean bl4 = n == Tag.MPI_ANYSOURCE;
            boolean bl5 = bl = n3 == Tag.MPI_ANYTAG;
            if (!bl2 && !bl4 || !bl3 && !bl) continue;
            iStatus.setStatus(recvBufferInformation.fromRank(), recvBufferInformation.getTag());
            this.expectedQueue.remove(i);
            return recvBufferInformation.getRequest();
        }
        return null;
    }

    public ByteBuffer getDataFromUnexpectedQueue(short s, int n, int n2, int n3, int n4, IStatus iStatus) {
        int n5 = this.unexpectedQueue.size();
        for (int i = 0; i < n5; ++i) {
            boolean bl;
            RecvBufferInformation recvBufferInformation = this.unexpectedQueue.elementAt(i);
            boolean bl2 = recvBufferInformation.commID() == s && recvBufferInformation.fromRank() == n && recvBufferInformation.toRank() == n2 && recvBufferInformation.numSend() == n4;
            boolean bl3 = recvBufferInformation.getTag() == n3;
            boolean bl4 = n == Tag.MPI_ANYSOURCE;
            boolean bl5 = bl = n3 == Tag.MPI_ANYTAG;
            if (!bl2 && !bl4 || !bl3 && !bl) continue;
            iStatus.setStatus(recvBufferInformation.fromRank(), recvBufferInformation.getTag());
            this.unexpectedQueue.remove(i);
            return recvBufferInformation.getData();
        }
        return null;
    }

    public void cleanupProcess() {
        Serializable serializable;
        Socket socket = null;
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            serializable = new GossipMessage(2, this.myHash);
            int n = this.getRankInList();
            serializable.setMyRank(n);
            socket = new Socket("127.0.0.1", this.fdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Fault Detection Service is not running");
        }
        try {
            serializable = new AppUnregisterMessage(this.myHash, this.myRank);
            socket = new Socket("127.0.0.1", this.mpdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("MPD Service is not running");
        }
    }

    public String getMessageID(short s, int n, int n2, int n3, int n4) {
        try {
            return new String(s + "_" + n + "_" + n2 + "_" + n3 + "_" + n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIORequest sendToBackup(RankTable rankTable, ByteBuffer byteBuffer, Vector<Integer> vector, short s, int n, int n2, int n3, int n4, int[] nArray) {
        String string = this.getMessageID(s, n, n2, n3, n4);
        Object object = this.sendLog;
        synchronized (object) {
            if (this.sendLog.isExist(string)) {
                this.sendLog.remove(string);
            } else {
                this.sendLog.add(string);
                SendBufferInformation sendBufferInformation = new SendBufferInformation(rankTable, byteBuffer, vector, s, n, n2, n3, n4, nArray);
                Vector<SendBufferInformation> vector2 = this.backupBuffer;
                synchronized (vector2) {
                    this.backupBuffer.addElement(sendBufferInformation);
                }
            }
        }
        object = new NIORequest();
        ((NIORequest)object).complete();
        ((NIORequest)object).fillStatus(n, n3, 0);
        return object;
    }

    public String getHashKey(short s, int n, int n2, int n3, int n4) {
        return s + "_" + n + "_" + n2 + "_" + n3 + "_" + n4;
    }

    public void registerMap(short s, MapRankTable mapRankTable) {
        this.commMap.put(Short.toString(s), mapRankTable);
    }

    public void registerCOMMWORLD(RankTable rankTable) {
        this.commWorld = rankTable;
    }

    public MapRankTable getMapRankTable(short s) {
        return (MapRankTable)this.commMap.get(Short.toString(s));
    }
}

