/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.Random;
import p2pmpi.common.MapRankTable;
import p2pmpi.message.AppRegisterMessage;
import p2pmpi.message.GossipMessage;
import p2pmpi.message.MPIMessage;
import p2pmpi.message.PingReplyMessage;
import p2pmpi.mpi.IntraComm;
import p2pmpi.mpi.MPI;
import p2pmpi.mpi.dev.NIODevice;
import p2pmpi.mpi.dev.NormalDevice;

class MPIClient
extends MPI {
    private int clientPort = 0;
    private ServerSocket reservedSocket = null;

    private int getMyPort() {
        return this.clientPort;
    }

    private ServerSocket getReservedSocket() {
        return this.reservedSocket;
    }

    private void setPorts(int n, int n2, long l) {
        int n3;
        int n4;
        mpiRandom = new Random(l);
        Random random = new Random();
        for (n4 = n3 = random.nextInt(n2 - n) + n; n4 <= n2; ++n4) {
            try {
                this.reservedSocket = new ServerSocket(n4);
                this.clientPort = n4;
                break;
            }
            catch (Exception exception) {
                this.reservedSocket = null;
                continue;
            }
        }
        if (this.reservedSocket == null) {
            for (n4 = n; n4 <= n2; ++n4) {
                try {
                    this.reservedSocket = new ServerSocket(n4);
                    this.clientPort = n4;
                    break;
                }
                catch (Exception exception) {
                    this.reservedSocket = null;
                    continue;
                }
            }
            if (this.reservedSocket == null) {
                System.err.println("** [Error] No allowed ports are available for running this application");
                System.exit(1);
            }
        }
    }

    public MPIClient(int n, int n2) {
        Object object;
        int n3;
        String string = System.getProperty("ip");
        int n4 = Integer.parseInt(System.getProperty("port"));
        myRank = Integer.parseInt(System.getProperty("rank"));
        myHash = System.getProperty("hashkey");
        Socket socket = null;
        ServerSocket serverSocket = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.setPorts(n, n2, Long.parseLong(myHash) + (long)myRank);
        n5 = this.getMyPort();
        serverSocket = this.getReservedSocket();
        myDevice = System.getProperty("device").equals("niodevice") ? new NIODevice() : (System.getProperty("device").equals("normaldevice") ? new NormalDevice() : new NIODevice());
        if (!myDevice.init(serverSocket, myHash, mpdPort, fdPort)) {
            System.err.println("** [Error] MPI NIOdevice init failed");
            System.exit(1);
        }
        if ((n6 = myDevice.initPort(n, n2, MPIClient.getLocalhostIP())) == -1) {
            System.err.println("** [Error] No allowed ports are available for running this application");
            System.exit(1);
        }
        if ((n7 = myDevice.initPort(n, n2, MPIClient.getLocalhostIP())) == -1) {
            System.err.println("** [Error] No allowed ports are available for running this application");
            System.exit(1);
        }
        try {
            cmdURI = new URI("tcp://" + MPIClient.getLocalhostIP() + ":" + n5);
            dataURI = new URI("tcp://" + MPIClient.getLocalhostIP() + ":" + n6);
            ctrlURI = new URI("tcp://" + MPIClient.getLocalhostIP() + ":" + n7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MPIMessage mPIMessage = null;
        mPIMessage = new MPIMessage(11);
        mPIMessage.setRank(myRank);
        mPIMessage.setFDPort(fdPort);
        mPIMessage.setURI(MPIClient.getLocalhostIP(), n5);
        mPIMessage.setDataURI(MPIClient.getLocalhostIP(), n6);
        mPIMessage.setCtrlURI(MPIClient.getLocalhostIP(), n7);
        boolean bl = false;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        for (int i = 0; i < 10; ++i) {
            try {
                socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n4);
                socket.connect(inetSocketAddress, 500);
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(mPIMessage);
                objectOutputStream.flush();
                objectOutputStream.close();
                outputStream.close();
                bl = true;
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!bl) {
            System.exit(1);
        }
        while (!myDevice.isRankTableReady()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        long l = System.currentTimeMillis();
        rankTable = myDevice.getRankTable();
        int n8 = myDevice.getRankInList();
        mapRankTable = new MapRankTable();
        for (n3 = 0; n3 < rankTable.size(); ++n3) {
            mapRankTable.addMap(rankTable.getRank(n3), rankTable.getRank(n3), n3);
        }
        n3 = rankTable.getRankInReplica(dataURI, n8);
        myDevice.connect(myRank, n3, n8, rankTable, rankTable.getNumProcess(), rankTable.getNumReplica());
        Thread thread = new Thread(myDevice);
        thread.setDaemon(true);
        thread.start();
        COMM_WORLD = new IntraComm(myDevice, rankTable, myDevice.getRank(), n8, myDevice.getCommSize(), mapRankTable);
        AppRegisterMessage appRegisterMessage = new AppRegisterMessage();
        appRegisterMessage.setID(myHash + "--" + myRank);
        appRegisterMessage.setRunCmd(System.getProperty("runCmd"));
        appRegisterMessage.setIPRank0(string);
        appRegisterMessage.setRunDir(System.getProperty("user.dir"));
        appRegisterMessage.setRank(myRank);
        appRegisterMessage.setPort(n5);
        appRegisterMessage.setMPISize(myDevice.getCommSize());
        appRegisterMessage.setRealSize(rankTable.size());
        appRegisterMessage.setRankTable(rankTable);
        try {
            object = new Socket("127.0.0.1", mpdPort);
            outputStream = ((Socket)object).getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(appRegisterMessage);
            objectOutputStream.flush();
            inputStream = ((Socket)object).getInputStream();
            objectInputStream = new ObjectInputStream(inputStream);
            PingReplyMessage pingReplyMessage = (PingReplyMessage)objectInputStream.readObject();
            objectInputStream.close();
            objectOutputStream.close();
            inputStream.close();
            outputStream.close();
            ((Socket)object).close();
        }
        catch (Exception exception) {
            System.err.println("** [Error] Make sure MPD is running");
            System.exit(-1);
        }
        object = new GossipMessage(0, myHash);
        ((GossipMessage)object).setMPIRank(myRank);
        ((GossipMessage)object).setMyRank(n8);
        ((GossipMessage)object).setMPIPort(n5);
        ((GossipMessage)object).setURIList(rankTable.getFDURIs());
        ((GossipMessage)object).setTGossip(myDevice.getTGossip());
        ((GossipMessage)object).setTMargin(myDevice.getTMargin());
        ((GossipMessage)object).setTHang(myDevice.getTHang());
        ((GossipMessage)object).setGossipProtocol(myDevice.getGossipProtocol());
        ((GossipMessage)object).setTDiff(System.currentTimeMillis(), (int)(System.currentTimeMillis() - l + (long)myDevice.getTDiff()));
        try {
            socket = new Socket("127.0.0.1", fdPort);
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            System.out.println("Fault Detection Service is not running");
            System.exit(1);
        }
    }
}

