/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.visu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import p2pmpi.common.ProcessInfo;
import p2pmpi.common.RankTable;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.visu.Fenetre;
import p2pmpi.visu.MyTableModel;
import p2pmpi.visu.NetMap;
import p2pmpi.visu.PeerNode;
import p2pmpi.visu.RefreshDisplay;
import p2pmpi.visu.Visu;
import p2pmpi.visu.taskTableModel;

public class Visu_Param {
    int peerDrawOption = 1;
    int peerOrderOption = 1;
    public Vector<StatInfoMessage> infoMsgs;
    public Vector<PeerNode> peers = new Vector();
    public Fenetre fen;
    public NetMap jc2;
    public static int refreshRate;
    public boolean textMode;
    public String currentTask;
    private JFrame jFrame = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JTextField maxNb = null;
    private JButton reloadButton = null;
    private JButton clearCacheButton = null;
    private JButton graphButton = null;
    private JButton LogButton = null;
    private ButtonGroup groupe = null;
    private JRadioButton jRadioButton = null;
    private JRadioButton jRadioButton1 = null;
    private JRadioButton jRadioButton2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    protected JLabel jLabel6 = null;
    public JTextField refresh = null;
    public JTable jdispTable = null;
    public JTable jtaskTable = null;
    private JScrollPane jScrollPane = null;
    protected static Logger log;
    public int nbscan = 0;
    public boolean IsLogging = false;
    public Visu parent;
    private RefreshDisplay refreshDisplayThread = null;
    private Thread runningDisplayThread = null;

    public Visu_Param(Visu visu, boolean bl) {
        log = Logger.getLogger((String)"VISU");
        log.info((Object)(" ****** Visu client starting at " + new Date() + " ******"));
        this.infoMsgs = new Vector();
        this.parent = visu;
        this.textMode = bl;
        log.debug((Object)"@ Visu_Param :: Visu_Param() --> creating NetMap.");
        this.jc2 = new NetMap(this);
        if (bl) {
            this.getJFrame();
        } else {
            this.getJFrame().setVisible(true);
        }
        log.debug((Object)"@ Visu_Param :: Visu_Param() -> preparing a RefreshDisplay object ... ");
        this.refreshDisplayThread = new RefreshDisplay(this);
        Thread thread = new Thread(this.refreshDisplayThread);
        thread.setName("RefreshDisplay thread");
        log.debug((Object)"@ Visu_Param :: Visu_Param() -> starting refreshDisplay thread ... ");
        thread.start();
    }

    public void fillPeers() {
        log.debug((Object)("@ Visu_Param::fillPeers () -> infoMsgs.size()=" + this.infoMsgs.size()));
        for (int i = 0; i < this.infoMsgs.size(); ++i) {
            StatInfoMessage statInfoMessage = this.infoMsgs.get(i);
            int n = statInfoMessage.size();
            log.debug((Object)("@ Visu_Param::fillPeers () ->  infoMsgs[k] ip=" + statInfoMessage.getIp() + ", numProcesses=" + n));
            if (n <= 0) continue;
            for (int j = 0; j < n; ++j) {
                ProcessInfo processInfo = statInfoMessage.getInfo(j);
                String string = processInfo.getRunCmd();
                RankTable rankTable = processInfo.getRankTable();
                for (int k = 0; k < rankTable.size(); ++k) {
                    int n2;
                    PeerNode peerNode = this.jc2.findNode(rankTable.getCmdHost(k).trim());
                    log.debug((Object)("@ Visu_Param::fillPeers () -> tmpPeer=" + peerNode.toString()));
                    if (peerNode == null) continue;
                    peerNode.setStatus("Working");
                    int n3 = -1;
                    for (int i2 = 0; i2 < peerNode.Tasks.size() && n3 == -1; ++i2) {
                        if (!string.trim().equals(peerNode.Tasks.get(i2).getCmd())) continue;
                        n3 = 1;
                        int n4 = -1;
                        for (n2 = 0; n2 < peerNode.Tasks.get((int)i2).Ranks.size() && n4 == -1; ++n2) {
                            if (peerNode.Tasks.get((int)i2).Ranks.get(n2).intValue() != rankTable.getRank(k)) continue;
                            peerNode.Tasks.get(i2).updateStatus(n2, rankTable.isAlive(k));
                            n4 = 1;
                        }
                        if (n4 != -1) continue;
                        peerNode.Tasks.get(i2).addRank(rankTable.getRank(k), rankTable.isAlive(k));
                    }
                    if (n3 == -1) {
                        n2 = 1;
                        if (processInfo.getMPISize() > 1) {
                            n2 = (processInfo.getRealSize() - 1) / (processInfo.getMPISize() - 1);
                        }
                        peerNode.newTask(string, rankTable.getRank(k), rankTable.isAlive(k), rankTable.size(), n2);
                    }
                    this.constructTaskData();
                }
                this.jc2.addComboTask(string);
            }
        }
    }

    public JFrame getJFrame() {
        if (!this.textMode) {
            if (this.jFrame == null) {
                this.jFrame = new JFrame();
                this.jFrame.setTitle("Monitor table");
                this.jFrame.setSize(619, 413);
                this.jFrame.setContentPane(this.getJPanel());
                WindowAdapter windowAdapter = new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        Visu_Param.this.refreshDisplayThread.quit();
                        System.exit(0);
                    }
                };
                this.jFrame.addWindowListener(windowAdapter);
            }
        } else {
            this.jFrame = null;
            this.getJPanel();
        }
        return this.jFrame;
    }

    private Panel getBottomButtonsPanel() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.jLabel6 = new JLabel("Scan results :");
        panel.setLayout(new BorderLayout(5, 5));
        panel2.add((Component)this.getGraphButton(), null);
        panel2.add((Component)this.getLogButton(), null);
        panel.add("Before", panel2);
        panel.add("Last", this.jLabel6);
        panel.add("After", this.getReloadButton());
        return panel;
    }

    private Panel getTopPanel() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        this.jLabel3 = new JLabel("Order by :");
        this.jLabel5 = new JLabel("Refresh time:");
        this.jLabel3.setBounds(30, 49, 115, 20);
        this.jLabel5.setBounds(25, 78, 109, 20);
        panel2.add((Component)this.jLabel3, null);
        panel2.add((Component)this.getJRadioButton(), null);
        panel2.add((Component)this.getJRadioButton1(), null);
        panel2.add((Component)this.getJRadioButton2(), null);
        this.groupe = new ButtonGroup();
        this.groupe.add(this.jRadioButton);
        this.groupe.add(this.jRadioButton1);
        this.groupe.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.peerOrderOption = 2;
        panel3.add((Component)this.jLabel5, null);
        panel3.add((Component)this.getRefresh(), null);
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("Before", panel2);
        panel.add("After", panel3);
        return panel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout(5, 5));
            this.jPanel.add("North", this.getTopPanel());
            this.jPanel.add("Center", this.getJScrollPane());
            this.jPanel.add("South", this.getBottomButtonsPanel());
            this.jScrollPane.setViewportView(this.getJdispTable());
        }
        return this.jPanel;
    }

    private JButton getReloadButton() {
        if (this.reloadButton == null) {
            this.reloadButton = new JButton();
            this.reloadButton.setBounds(379, 120, 218, 22);
            this.reloadButton.setText("Reload");
            this.reloadButton.setSelected(true);
            this.reloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    if ((actionEvent.getModifiers() & 1) != 0) {
                        bl = true;
                    }
                    Visu_Param.this.reload(bl);
                }
            });
        }
        return this.reloadButton;
    }

    private JButton getGraphButton() {
        if (this.graphButton == null) {
            this.graphButton = new JButton();
            this.graphButton.setText("Graphical view");
            this.graphButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Visu_Param.this.peers == null || Visu_Param.this.peers.size() == 0) {
                        System.out.println("No data to display yet");
                    } else if (Visu_Param.this.fen == null) {
                        log.debug((Object)"@ Visu_Param::graphButton pressed.");
                        Visu_Param.this.fen = new Fenetre(Visu_Param.this.jc2, "Nodes Graph");
                    }
                }
            });
        }
        return this.graphButton;
    }

    public void writeLog() {
        if (this.IsLogging) {
            log.info((Object)(((MyTableModel)this.jdispTable.getModel()).toString() + ((taskTableModel)this.jtaskTable.getModel()).toString()));
        }
    }

    private JButton getLogButton() {
        if (this.LogButton == null) {
            this.LogButton = new JButton();
            this.LogButton.setText("Logger");
            this.LogButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Visu_Param.this.IsLogging) {
                        Visu_Param.this.IsLogging = true;
                        log.info((Object)"runVisu Started Logging on user demand");
                        Visu_Param.this.LogButton.setText("Stop Logger");
                    } else {
                        Visu_Param.this.LogButton.setText("Logger");
                        Visu_Param.this.IsLogging = false;
                        log.info((Object)"runVisu Stopped Logging on user demand");
                    }
                }
            });
        }
        return this.LogButton;
    }

    private JRadioButton getJRadioButton() {
        if (this.jRadioButton == null) {
            this.jRadioButton = new JRadioButton();
            this.jRadioButton.setBounds(168, 52, 59, 16);
            this.jRadioButton.setText("Rank");
            this.jRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Visu_Param.this.peerOrderOption = 1;
                    if (Visu_Param.this.jScrollPane != null) {
                        Visu_Param.this.jScrollPane.setViewportView(Visu_Param.this.getJtaskTable());
                    }
                }
            });
        }
        return this.jRadioButton;
    }

    private JRadioButton getJRadioButton1() {
        if (this.jRadioButton1 == null) {
            this.jRadioButton1 = new JRadioButton();
            this.jRadioButton1.setBounds(234, 48, 93, 23);
            this.jRadioButton1.setText("Subnet");
            this.jRadioButton1.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Visu_Param.this.peerOrderOption = 3;
                }
            });
        }
        return this.jRadioButton1;
    }

    private JRadioButton getJRadioButton2() {
        if (this.jRadioButton2 == null) {
            this.jRadioButton2 = new JRadioButton();
            this.jRadioButton2.setBounds(324, 52, 132, 17);
            this.jRadioButton2.setText("disponibility");
            this.jRadioButton2.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    Visu_Param.this.peerOrderOption = 2;
                    if (Visu_Param.this.jScrollPane != null) {
                        Visu_Param.this.jScrollPane.setViewportView(Visu_Param.this.getJdispTable());
                    }
                }
            });
        }
        return this.jRadioButton2;
    }

    private JTextField getRefresh() {
        if (this.refresh == null) {
            this.refresh = new JTextField();
            this.refresh.setBounds(186, 78, 67, 15);
            this.refresh.setText("30");
        }
        return this.refresh;
    }

    private JTable getJtaskTable() {
        if (this.jtaskTable == null) {
            this.jtaskTable = new JTable(new taskTableModel(this));
        }
        return this.jtaskTable;
    }

    private JTable getJdispTable() {
        if (this.jdispTable == null) {
            log.debug((Object)"@ Visu_Param::getJdispTable()-> new JTable(new MyTableModel(this)");
            this.jdispTable = new JTable(new MyTableModel(this));
        }
        return this.jdispTable;
    }

    private JTable getJTable() {
        switch (this.peerOrderOption) {
            case 1: {
                this.getJdispTable();
                return this.getJtaskTable();
            }
            case 2: {
                this.getJtaskTable();
                return this.getJdispTable();
            }
        }
        return null;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(25, 146, 565, 201);
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    public void setReloadCommandsVisible(boolean bl) {
        this.jLabel5.setVisible(bl);
        this.refresh.setVisible(bl);
        this.reloadButton.setVisible(bl);
    }

    public void reload(boolean bl) {
        log.debug((Object)("@ Visu_Param :: scan() -> clearCache=" + bl + ", textMode=" + this.textMode));
        this.refreshDisplayThread.setClearCache(bl);
        this.refreshDisplayThread.monitorReloadOrRefresh(0L);
    }

    public void refreshTables() {
        log.debug((Object)"@ Visu_Param :: refreshTable()");
        System.out.flush();
        ((MyTableModel)this.jdispTable.getModel()).fireTableDataChanged();
        ((taskTableModel)this.jtaskTable.getModel()).fireTableDataChanged();
        if (this.textMode) {
            System.out.printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", new Object[0]);
            System.out.println(((MyTableModel)this.jdispTable.getModel()).toString());
            System.out.printf("\n\n", new Object[0]);
            System.out.println(((taskTableModel)this.jtaskTable.getModel()).toString());
        }
    }

    public void constructTaskData() {
        ((taskTableModel)this.jtaskTable.getModel()).constructData();
    }
}

