/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.mpi.dev;

import java.nio.ByteBuffer;
import java.util.Vector;
import p2pmpi.mpi.dev.IStatus;
import p2pmpi.mpi.dev.P2PMPI_Buffer;
import p2pmpi.mpi.dev.SmallRequest;

public class NIORequest {
    protected Object recvBuffer;
    protected int offset;
    protected int count;
    protected int src;
    protected int tag;
    protected int dst;
    Vector<SmallRequest> reqList;
    P2PMPI_Buffer buffer;
    IStatus status = null;
    protected volatile boolean completed;

    public NIORequest() {
        this.reqList = new Vector();
        this.completed = false;
    }

    public NIORequest(Object object, int n, int n2, int n3, int n4, int n5, P2PMPI_Buffer p2PMPI_Buffer) {
        this.recvBuffer = object;
        this.offset = n;
        this.count = n2;
        this.src = n3;
        this.dst = n4;
        this.tag = n5;
        this.buffer = p2PMPI_Buffer;
        this.reqList = new Vector();
        this.completed = false;
    }

    public void fillStatus(IStatus iStatus) {
        this.status = iStatus;
    }

    public void fillStatus(int n, int n2, int n3) {
        this.status = new IStatus(n, n2, n3);
    }

    public void fillStatus(IStatus iStatus, int n) {
        this.status = iStatus;
        this.status.setLength(n);
    }

    public synchronized void complete() {
        this.completed = true;
        try {
            this.notify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void add(SmallRequest smallRequest) {
        this.reqList.addElement(smallRequest);
    }

    public int addData(ByteBuffer byteBuffer, int n) {
        return this.buffer.fillRecvData(this.recvBuffer, this.offset, this.count, byteBuffer, n);
    }

    public IStatus Wait() {
        int n = this.reqList.size();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                this.reqList.elementAt(i).Wait();
            }
        } else {
            while (!this.completed) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
        }
        return this.status;
    }

    public IStatus Test() {
        return this.status;
    }
}

