/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.File;
import java.net.URI;
import org.apache.log4j.Logger;
import p2pmpi.common.GenericConfigFile;

public class P2PMPI_ConfigFile
extends GenericConfigFile {
    static String numCPU = "NUM_CPU";
    static String mpdPort = "MPD_PORT";
    static String ftPort = "FT_PORT";
    static String fdPort = "FD_PORT";
    static String jxtaMinPort = "MIN_PORT";
    static String jxtaMaxPort = "MAX_PORT";
    static String tmpDir = "TMP_DIR";
    static String externalIP = "EXTERNAL_IP";
    static String hostDeny = "HOST_DENY";
    static String hostAllow = "HOST_ALLOW";
    static String t_gossip = "T_GOSSIP";
    static String t_margin = "T_MAX_STARTUP";
    static String gossipProtocol = "GOSSIP_PROTOCOL";
    static String t_hang = "T_MAX_HANG";
    static String numProcPerJob = "MAX_PROCESSES_PER_JOB";
    static String maxJob = "MAX_JOBS";
    static String rsPort = "RS_PORT";
    static String peerCache = "PEER_CACHE";
    static int t_gossip_default = 500;
    static int t_hang_default = 0;
    static String supernode = "SUPERNODE";
    static String visuproxy = "VISU_PROXY";
    Logger logger = null;

    public P2PMPI_ConfigFile(String string) {
        super(string);
    }

    public P2PMPI_ConfigFile(String string, Logger logger) {
        super(string);
        this.logger = logger;
    }

    public P2PMPI_ConfigFile() {
        String string = System.getProperty("P2PMPI_CONF_FILE");
        String string2 = System.getProperty("P2PMPI_HOME");
        if (string2 == null || string2.equals("")) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        File file = null;
        if (string == null || string.equals("")) {
            string = "P2P-MPI.conf";
            file = new File(string2, string);
        } else {
            file = new File(string);
        }
        try {
            if (file.isFile()) {
                super.setFileName(file.toString());
            } else {
                System.err.println("[Error] cannot access configuration file:" + string + ". Exiting.");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public P2PMPI_ConfigFile(Logger logger) {
        this.logger = logger;
        String string = System.getProperty("P2PMPI_CONF_FILE");
        String string2 = System.getProperty("P2PMPI_HOME");
        if (string2 == null || string2.equals("")) {
            System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
            System.exit(1);
        }
        File file = null;
        if (string == null || string.equals("")) {
            string = "P2P-MPI.conf";
            file = new File(string2, string);
        } else {
            file = new File(string);
        }
        try {
            if (file.isFile()) {
                super.setFileName(file.toString());
            } else {
                System.err.println("[Error] cannot access configuration file:" + string + ". Exiting.");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URI getSuperNode() {
        try {
            return new URI(this.getProperty(supernode));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI getVisuProxy() {
        try {
            return new URI(this.getProperty(visuproxy));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getGossipProtocol() {
        String string = this.getProperty(gossipProtocol);
        if (string == null) {
            return "DBRR";
        }
        if (!string.equalsIgnoreCase("DBRR") && !string.equalsIgnoreCase("BRR")) {
            return "DBRR";
        }
        return string;
    }

    public int getNumCPU() {
        int n;
        try {
            n = Integer.parseInt(this.getProperty(numCPU));
        }
        catch (Exception exception) {
            return 1;
        }
        if (n <= 1) {
            return 1;
        }
        return n;
    }

    public int getTGossip() {
        try {
            int n = Integer.parseInt(this.getProperty(t_gossip));
            if (n < t_gossip_default) {
                return t_gossip_default;
            }
            return Integer.parseInt(this.getProperty(t_gossip));
        }
        catch (Exception exception) {
            return t_gossip_default;
        }
    }

    public int getTHang() {
        try {
            return Integer.parseInt(this.getProperty(t_hang));
        }
        catch (Exception exception) {
            return t_hang_default;
        }
    }

    public int getFTPort() {
        return Integer.parseInt(this.getProperty(ftPort));
    }

    public int getFDPort() {
        return Integer.parseInt(this.getProperty(fdPort));
    }

    public int getMPDPort() {
        return Integer.parseInt(this.getProperty(mpdPort));
    }

    public int getMinPort() {
        return Integer.parseInt(this.getProperty(jxtaMinPort));
    }

    public int getMaxPort() {
        return Integer.parseInt(this.getProperty(jxtaMaxPort));
    }

    public int getMaxJob() {
        return Integer.parseInt(this.getProperty(maxJob, this.logger));
    }

    public int getNumProcPerJob() {
        String string = this.getProperty(numProcPerJob, this.logger);
        if (string == null) {
            return 1;
        }
        return Integer.parseInt(string);
    }

    public String getTempDirectory() {
        return this.getProperty(tmpDir);
    }

    public String getExternalIP() {
        return this.getProperty(externalIP);
    }

    public String getHostDeny() {
        return this.getProperty(hostDeny);
    }

    public String getHostAllow() {
        return this.getProperty(hostAllow);
    }

    public int getRSPort() {
        return Integer.parseInt(this.getProperty(rsPort));
    }

    public String getPeerCacheFile() {
        return this.getProperty(peerCache);
    }
}

