/*
 * Decompiled with CFR 0.152.
 */
package p2pmpi.common;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class OsInfo {
    private static String[] normalizedOsCategory = new String[]{"Linux", "Windows", "Macosx", "SunOS"};

    public static String getName() {
        return System.getProperty("os.name");
    }

    public static boolean equalsOs(String string, String string2) {
        String string3 = string.replaceAll(" ", "").toLowerCase();
        return string3.startsWith(string2.toLowerCase());
    }

    public static boolean isLinux(String string) {
        return OsInfo.equalsOs(string, normalizedOsCategory[0]);
    }

    public static boolean isWindows(String string) {
        return OsInfo.equalsOs(string, normalizedOsCategory[1]);
    }

    public static boolean isMacosx(String string) {
        return OsInfo.equalsOs(string, normalizedOsCategory[2]);
    }

    public static String normalizedOsInfo(String string) {
        for (int i = 0; i < normalizedOsCategory.length; ++i) {
            if (!OsInfo.equalsOs(string, normalizedOsCategory[i])) continue;
            return normalizedOsCategory[i];
        }
        return "Unknown";
    }

    public static String[] cpuInfo() {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray2 = null;
        String string = OsInfo.getName();
        if (OsInfo.isLinux(string)) {
            try {
                object3 = new FileInputStream("/proc/cpuinfo");
                object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                boolean bl = false;
                stringArray2 = new String[2];
                while (!bl) {
                    object = ((BufferedReader)object2).readLine();
                    if (((String)object).startsWith("model name")) {
                        stringArray = ((String)object).split(":", 2);
                        stringArray2[0] = new String(stringArray[1]);
                    }
                    if (!((String)object).startsWith("cpu MHz")) continue;
                    stringArray = ((String)object).split(":", 2);
                    stringArray2[1] = new String(stringArray[1]);
                    bl = true;
                }
                ((BufferedReader)object2).close();
            }
            catch (Exception exception) {
                System.err.println("** Warning: could not read /proc/cpuinfo filesystem.");
            }
        }
        if (OsInfo.isMacosx(string)) {
            object3 = "hw.model =";
            object2 = "hw.cpufrequency =";
            try {
                Process process = Runtime.getRuntime().exec("sysctl hw");
                object = process.getInputStream();
                stringArray = new InputStreamReader((InputStream)object);
                BufferedReader bufferedReader = new BufferedReader((Reader)stringArray);
                String string2 = null;
                stringArray2 = new String[2];
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith((String)object3)) {
                        stringArray2[0] = string2.substring(string2.indexOf("=") + 1);
                    }
                    if (!string2.startsWith((String)object2)) continue;
                    stringArray2[1] = string2.substring(string2.indexOf("=") + 1);
                }
                if (stringArray2[0] == null || stringArray2[1] == null) {
                    stringArray2 = null;
                }
                int n = process.waitFor();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return stringArray2;
    }

    public static String[] memInfo() {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray2 = null;
        String string = OsInfo.getName();
        if (OsInfo.isLinux(string)) {
            try {
                object3 = new FileInputStream("/proc/meminfo");
                object2 = new BufferedReader(new InputStreamReader((InputStream)object3));
                object = ((BufferedReader)object2).readLine();
                stringArray = ((String)object).split(":", 2);
                stringArray2 = new String[]{new String(stringArray[1])};
                ((BufferedReader)object2).close();
            }
            catch (Exception exception) {
                System.err.println("** Warning: could not read /proc/meminfo filesystem.");
            }
        }
        if (OsInfo.isMacosx(string)) {
            object3 = "hw.memsize:";
            try {
                object2 = Runtime.getRuntime().exec("sysctl -a hw");
                object = ((Process)object2).getInputStream();
                stringArray = new InputStreamReader((InputStream)object);
                BufferedReader bufferedReader = new BufferedReader((Reader)stringArray);
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.startsWith((String)object3)) continue;
                    stringArray2 = new String[]{string2.substring(string2.indexOf(":") + 1)};
                }
                int n = ((Process)object2).waitFor();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        String string = OsInfo.getName();
        System.out.println("Exact system name as returned by  System.getProperty() : " + string);
        System.out.println("normalizedOsInfo(" + string + ") : " + OsInfo.normalizedOsInfo(string));
        System.out.println("normalizedOsInfo(Mac Os X) : " + OsInfo.normalizedOsInfo("Mac Os X"));
        System.out.println("Is Linux : " + OsInfo.isLinux(string));
        System.out.println("Is Windows : " + OsInfo.isWindows(string));
        System.out.println("Is MacOSX : " + OsInfo.isMacosx(string));
        String[] stringArray2 = OsInfo.cpuInfo();
        String[] stringArray3 = OsInfo.memInfo();
        if (stringArray2 != null) {
            System.out.println("CPU model:" + stringArray2[0] + " / " + stringArray2[1] + "MHz");
        } else {
            System.out.println("CPU model: N/A");
        }
        if (stringArray3 != null) {
            System.out.println("RAM:" + stringArray3[0]);
        } else {
            System.out.println("RAM: N/A");
        }
    }
}

