/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPaintListener;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class HVRotateDragUI
extends TGAbstractDragUI
implements TGPaintListener {
    HVScroll hvScroll;
    RotateScroll rotateScroll;
    Node mouseOverN;
    Node tempNode;
    TGPoint2D lastMousePos;
    double lastAngle;

    public HVRotateDragUI(TGPanel tGPanel, HVScroll hVScroll, RotateScroll rotateScroll) {
        super(tGPanel);
        this.hvScroll = hVScroll;
        this.rotateScroll = rotateScroll;
    }

    double graphDist(double d, double d2) {
        double d3 = d - this.tgPanel.getDrawCenter().x;
        double d4 = d2 - this.tgPanel.getDrawCenter().y;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    double getMouseAngle(double d, double d2) {
        double d3 = d - this.tgPanel.getDrawCenter().x;
        double d4 = d2 - this.tgPanel.getDrawCenter().y;
        double d5 = Math.atan(d4 / d3);
        if (d3 == 0.0) {
            d5 = d4 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (d3 < 0.0) {
            d5 += Math.PI;
        }
        return d5;
    }

    public void preActivate() {
        this.tgPanel.addPaintListener(this);
    }

    public void preDeactivate() {
        this.tgPanel.removePaintListener(this);
        this.tgPanel.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseOverN = this.tgPanel.getMouseOverN();
        if (this.mouseOverN != null) {
            this.lastMousePos = new TGPoint2D(this.mouseOverN.drawx, this.mouseOverN.drawy);
            this.lastAngle = this.getMouseAngle(this.mouseOverN.drawx, this.mouseOverN.drawy);
        } else {
            this.tempNode = new Node();
            this.tempNode.drawx = mouseEvent.getX();
            this.tempNode.drawy = mouseEvent.getY();
            this.tgPanel.updatePosFromDraw(this.tempNode);
            this.lastMousePos = new TGPoint2D(this.tempNode.drawx, this.tempNode.drawy);
            this.lastAngle = this.getMouseAngle(this.tempNode.drawx, this.tempNode.drawy);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        double d3 = this.graphDist(d, d2);
        this.lastAngle = this.mouseOverN != null ? this.getMouseAngle(this.mouseOverN.drawx, this.mouseOverN.drawy) : this.getMouseAngle(this.tempNode.drawx, this.tempNode.drawy);
        double d4 = this.getMouseAngle(d, d2);
        if (this.lastAngle > d4 + Math.PI) {
            d4 += Math.PI * 2;
        } else if (d4 > this.lastAngle + Math.PI) {
            this.lastAngle += Math.PI * 2;
        }
        if (d3 > 60.0) {
            this.rotateScroll.incrementRotateAngle(d4 - this.lastAngle);
        }
        this.tgPanel.updateDrawPositions();
        this.tgPanel.updateGraphSize();
        if (this.tempNode != null) {
            this.tgPanel.updateDrawPos(this.tempNode);
        }
        TGPoint2D tGPoint2D = this.mouseOverN != null ? new TGPoint2D(this.mouseOverN.drawx, this.mouseOverN.drawy) : new TGPoint2D(this.tempNode.drawx, this.tempNode.drawy);
        TGPoint2D tGPoint2D2 = new TGPoint2D(d, d2);
        if (!this.hvScroll.scrolling) {
            this.hvScroll.scrollAtoB(tGPoint2D, tGPoint2D2);
        }
        this.tgPanel.repaintAfterMove();
        if (this.tempNode != null) {
            this.tgPanel.updateDrawPos(this.tempNode);
        }
    }

    public void paintFirst(Graphics graphics) {
        TGPoint2D tGPoint2D = this.tgPanel.getDrawCenter();
        graphics.setColor(Color.lightGray);
        for (int i = 0; i < 16; ++i) {
            double d = Math.PI * 2 * (double)i / 16.0;
            double d2 = 1000.0 * Math.cos(d);
            double d3 = 1000.0 * Math.sin(d);
            graphics.drawLine((int)tGPoint2D.x, (int)tGPoint2D.y, (int)(d2 + tGPoint2D.x), (int)(d3 + tGPoint2D.y));
            graphics.drawLine((int)tGPoint2D.x + 1, (int)tGPoint2D.y, (int)(d2 + tGPoint2D.x + 1.0), (int)(d3 + tGPoint2D.y));
            graphics.drawLine((int)tGPoint2D.x, (int)tGPoint2D.y + 1, (int)(d2 + tGPoint2D.x), (int)(d3 + tGPoint2D.y + 1.0));
            graphics.drawLine((int)tGPoint2D.x + 1, (int)tGPoint2D.y + 1, (int)(d2 + tGPoint2D.x + 1.0), (int)(d3 + tGPoint2D.y + 1.0));
        }
        graphics.fillOval((int)tGPoint2D.x - 60, (int)tGPoint2D.y - 60, 120, 120);
        graphics.setColor(TGPanel.BACK_COLOR);
        graphics.fillOval((int)tGPoint2D.x - 58, (int)tGPoint2D.y - 58, 116, 116);
    }

    public void paintLast(Graphics graphics) {
    }

    public void paintAfterEdges(Graphics graphics) {
    }
}

