/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.TGForEachNodePair;

public class TGLayout
implements Runnable {
    private TGPanel tgPanel;
    private Thread relaxer;
    private double damper = 0.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private boolean damping = true;
    private double rigidity = 1.0;
    private double newRigidity = 1.0;
    Node dragNode = null;

    public TGLayout(TGPanel tGPanel) {
        this.tgPanel = tGPanel;
        this.relaxer = null;
    }

    void setRigidity(double d) {
        this.newRigidity = d;
    }

    void setDragNode(Node node) {
        this.dragNode = node;
    }

    private synchronized void relaxEdges() {
        TGForEachEdge tGForEachEdge = new TGForEachEdge(){

            public void forEachEdge(Edge edge) {
                double d = edge.to.x - edge.from.x;
                double d2 = edge.to.y - edge.from.y;
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d * TGLayout.this.rigidity;
                double d5 = d2 * TGLayout.this.rigidity;
                d4 /= (double)(edge.getLength() * 100);
                d5 /= (double)(edge.getLength() * 100);
                if (edge.to.justMadeLocal || !edge.from.justMadeLocal) {
                    edge.to.dx -= d4 * d3;
                    edge.to.dy -= d5 * d3;
                } else {
                    edge.to.dx -= d4 * d3 / 10.0;
                    edge.to.dy -= d5 * d3 / 10.0;
                }
                if (edge.from.justMadeLocal || !edge.to.justMadeLocal) {
                    edge.from.dx += d4 * d3;
                    edge.from.dy += d5 * d3;
                } else {
                    edge.from.dx += d4 * d3 / 10.0;
                    edge.from.dy += d5 * d3 / 10.0;
                }
            }
        };
        this.tgPanel.getGES().forAllEdges(tGForEachEdge);
    }

    private synchronized void avoidLabels() {
        TGForEachNodePair tGForEachNodePair = new TGForEachNodePair(){

            public void forEachNodePair(Node node, Node node2) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = node.x - node2.x;
                double d4 = node.y - node2.y;
                double d5 = d3 * d3 + d4 * d4;
                if (d5 == 0.0) {
                    d = Math.random();
                    d2 = Math.random();
                } else if (d5 < 360000.0) {
                    d = d3 / d5;
                    d2 = d4 / d5;
                }
                int n = node.repulsion * node2.repulsion / 100;
                if (node.justMadeLocal || !node2.justMadeLocal) {
                    node.dx += d * (double)n * TGLayout.this.rigidity;
                    node.dy += d2 * (double)n * TGLayout.this.rigidity;
                } else {
                    node.dx += d * (double)n * TGLayout.this.rigidity / 10.0;
                    node.dy += d2 * (double)n * TGLayout.this.rigidity / 10.0;
                }
                if (node2.justMadeLocal || !node.justMadeLocal) {
                    node2.dx -= d * (double)n * TGLayout.this.rigidity;
                    node2.dy -= d2 * (double)n * TGLayout.this.rigidity;
                } else {
                    node2.dx -= d * (double)n * TGLayout.this.rigidity / 10.0;
                    node2.dy -= d2 * (double)n * TGLayout.this.rigidity / 10.0;
                }
            }
        };
        this.tgPanel.getGES().forAllNodePairs(tGForEachNodePair);
    }

    public void startDamper() {
        this.damping = true;
    }

    public void stopDamper() {
        this.damping = false;
        this.damper = 1.0;
    }

    public void resetDamper() {
        this.damping = true;
        this.damper = 1.0;
    }

    public void stopMotion() {
        this.damping = true;
        this.damper = this.damper > 0.3 ? 0.3 : 0.0;
    }

    public void damp() {
        if (this.damping && this.motionRatio <= 0.001) {
            if ((this.maxMotion < 0.2 || this.maxMotion > 1.0 && this.damper < 0.9) && this.damper > 0.01) {
                this.damper -= 0.01;
            } else if (this.maxMotion < 0.4 && this.damper > 0.003) {
                this.damper -= 0.003;
            } else if (this.damper > 1.0E-4) {
                this.damper -= 1.0E-4;
            }
        }
        if (this.maxMotion < 0.001 && this.damping) {
            this.damper = 0.0;
        }
    }

    private synchronized void moveNodes() {
        this.lastMaxMotion = this.maxMotion;
        final double[] dArray = new double[]{0.0};
        TGForEachNode tGForEachNode = new TGForEachNode(){

            public void forEachNode(Node node) {
                double d = node.dx;
                double d2 = node.dy;
                node.dx = (d *= TGLayout.this.damper) / 2.0;
                node.dy = (d2 *= TGLayout.this.damper) / 2.0;
                double d3 = Math.sqrt(d * d + d2 * d2);
                if (!node.fixed && node != TGLayout.this.dragNode) {
                    node.x += Math.max(-30.0, Math.min(30.0, d));
                    node.y += Math.max(-30.0, Math.min(30.0, d2));
                }
                dArray[0] = Math.max(d3, dArray[0]);
            }
        };
        this.tgPanel.getGES().forAllNodes(tGForEachNode);
        this.maxMotion = dArray[0];
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    private synchronized void relax() {
        for (int i = 0; i < 10; ++i) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
        }
        if (this.rigidity != this.newRigidity) {
            this.rigidity = this.newRigidity;
        }
        this.tgPanel.repaintAfterMove();
    }

    private void myWait() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.relaxer == thread) {
            this.relax();
            try {
                Thread.sleep(20L);
                while (this.damper < 0.1 && this.damping && this.maxMotion < 0.001) {
                    this.myWait();
                }
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void stop() {
        this.relaxer = null;
    }
}

