package p2pmpi.visu;

import p2pmpi.message.MessageCmd;
import p2pmpi.message.MPDMessage;
import p2pmpi.message.StatQueryMessage;
import p2pmpi.message.StatInfoMessage;
import p2pmpi.common.*;

import java.util.*;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;
import org.apache.log4j.*;
/*
 * Created on 25 avr. 2005
 */

/**
 * @author ghazi, genaud, choopan
 *
 */
public class Visu_Param {

	  int peerDrawOption=1;  // 1:HostName, 2:IP adress
	  int peerOrderOption=1; //order by 1:Rank ,  2:just show available MPDs , 3:IP subnets

	  public Vector<StatInfoMessage> infoMsgs;
	  public Vector<PeerNode> peers = new Vector<PeerNode>(); //information items attached to graphic elements
	  public Fenetre fen;
	  public NetMap jc2;
	  public static int refreshRate;
	  public boolean textMode;
	  public String currentTask;

	  private JFrame jFrame = null;  
        private JPanel jPanel = null;
	  private JLabel jLabel = null;
	  private JTextField maxNb = null;
	  private JButton reloadButton = null;
	  private JButton clearCacheButton = null;
	  private JButton graphButton = null;
	  private JButton LogButton = null;
	  private ButtonGroup groupe = null;
	  private JRadioButton jRadioButton = null;
	  private JRadioButton jRadioButton1 = null;
	  private JRadioButton jRadioButton2 = null;
	  private JLabel jLabel3 = null;
	  private JLabel jLabel4 = null;
	  private JLabel jLabel5 = null;
	  protected JLabel jLabel6 = null;
	  public JTextField refresh = null;
	  public JTable jdispTable = null;
	  public JTable jtaskTable = null;
	  private JScrollPane jScrollPane = null;

	  protected static Logger log;
	  public int nbscan=0;
	  public boolean IsLogging=false;
	  public Visu parent;
	  private RefreshDisplay refreshDisplayThread=null;
	  private Thread runningDisplayThread=null;


	  /**
	   * constructor.
	   **/
	  public Visu_Param( Visu parent, boolean textMode ){
		    // init a logger
		    log = Logger.getLogger("VISU");

                log.info(" ****** Visu client starting at " + new java.util.Date() + " ******");

		    infoMsgs = new Vector(); 
		    this.parent = parent;	
		    this.textMode = textMode;

		    log.debug("@ Visu_Param :: Visu_Param() --> creating NetMap.");
		    jc2 = new NetMap(this);

		    if ( textMode )
				getJFrame();
		    else
				getJFrame().setVisible(true);
		    // prepare a thread that will handle updated display of information
		    log.debug("@ Visu_Param :: Visu_Param() -> preparing a RefreshDisplay object ... ");
		    refreshDisplayThread = new RefreshDisplay( this  );
		    Thread runningDisplayThread = new Thread( refreshDisplayThread );
		    runningDisplayThread.setName("RefreshDisplay thread");
		    log.debug("@ Visu_Param :: Visu_Param() -> starting refreshDisplay thread ... ");
		    runningDisplayThread.start();

	  }

	  /**
	   * fillPeers.
	   * fills peers infos fields with /procinfo data.
	   * 
	   */
	  public void fillPeers(){ 
		    log.debug("@ Visu_Param::fillPeers () -> infoMsgs.size()="+infoMsgs.size());
		    for(int k=0;k<infoMsgs.size();k++){ 
				StatInfoMessage infoMsg = infoMsgs.get(k);
				ProcessInfo procInfo;
				int numProcess = infoMsg.size();
				log.debug("@ Visu_Param::fillPeers () ->  infoMsgs[k] ip=" + infoMsg.getIp() + ", numProcesses="+numProcess);

				if(numProcess>0) {
					  for(int i = 0; i < numProcess; i++) {
						    procInfo = infoMsg.getInfo(i);

						    //ici on remplit le vecteur de peers de P2PMPI_Visu avec les infos
						    //il faut d'abord chercher a quel peer correspond ce procinfo
						    String cmd = procInfo.getRunCmd();
						    RankTable comm = procInfo.getRankTable();

						    int l;
						    for(l=0;l<comm.size();l++) {	
								PeerNode tmpPeer = (PeerNode)jc2.findNode(comm.getHost(l).trim());
								// getHost() comes from p2pmpi/common/RankTable.java and returns the host IP */
								log.debug("@ Visu_Param::fillPeers () -> tmpPeer="+tmpPeer.toString() );
								if(tmpPeer!=null) {	//we change the peer Status to "Working"
									  tmpPeer.setStatus("Working");

									  // Test if this task is known 
									  int f=0;
									  int foundTask=-1;
									  while ( f < (tmpPeer.Tasks).size() && foundTask==-1) {
										    if( cmd.trim().equals((tmpPeer.Tasks.get(f)).getCmd())) {
												foundTask=1;
												// test if the rank is known
												int g=0;
												int trouveRang=-1;

												while(g< (tmpPeer.Tasks.get(f)).Ranks.size() && trouveRang==-1){
													  if(((Integer)
																	  (tmpPeer.Tasks.get(f)).Ranks.get(g)).intValue()==comm.getRank(l)) {
														    //Si oui on met le RankStatus a jour
														    //((Task)tmpPeer.Tasks.get(f)).RankStatus.set(g,comm.isAlive(l));
														    (tmpPeer.Tasks.get(f)).updateStatus(g,comm.isAlive(l));
														    trouveRang=1;
													  }
													  g++;
												}
												if (trouveRang==-1) //Si non on ajoute un RAnk et un RAnkStatus
												{	
													  ((Task)tmpPeer.Tasks.get(f)).addRank(comm.getRank(l),comm.isAlive(l));

												}
										    }
										    f++;
									  }
									  if(foundTask==-1) // if the task isn't known, add a new task.
									  {
										    // we calculate the number of replicas = (realsize-1)/(mpisize-1) 
										    int nbReplicas=1; //case mpisize=1
										    if(procInfo.getMPISize()>1)
												nbReplicas = (procInfo.getRealSize()-1)/(procInfo.getMPISize()-1);					

										    tmpPeer.newTask(cmd,comm.getRank(l),comm.isAlive(l),comm.size(),nbReplicas);

									  }
									  constructTaskData();

									  //	addReplicaNode(cmd,tmpPeer,comm.getRank(l));
								}

						    }
						    jc2.addComboTask(cmd);
					  }
				}
		    }

	  }


	  public JFrame getJFrame() {
		    if(!textMode){
				if (jFrame == null) {
					  jFrame = new JFrame();
					  jFrame.setTitle("Monitor table");
					  jFrame.setSize(619, 413);

					  jFrame.setContentPane(getJPanel());
					  WindowAdapter wa = new WindowAdapter() {
						    public void windowClosing(WindowEvent e) {
								refreshDisplayThread.quit( );
								System.exit(0);
						    }
					  };
					  jFrame.addWindowListener(wa);
				}
		    }
		    else{
				jFrame=null;
				getJPanel();
		    }
		    return jFrame;
	  }


	  private Panel getBottomButtonsPanel() {
		    Panel p = new Panel();
		    Panel pleft = new Panel();
		    jLabel6 = new JLabel("Scan results :");
		    p.setLayout(new BorderLayout(5, 5)); // hor and vert space bewtween borders 
		    pleft.add(getGraphButton(),null);  // add graph butt.
		    pleft.add(getLogButton(),null);    // add log butt.
		    p.add(BorderLayout.LINE_START,pleft);  // add graph butt.
		    p.add(BorderLayout.PAGE_END,jLabel6);
		    p.add(BorderLayout.LINE_END,getReloadButton());
		    return(p);
	  }

	  private Panel getTopPanel() {
		    Panel p = new Panel();
		    Panel pleft = new Panel();
		    Panel pright = new Panel();

		    jLabel3 = new JLabel("Order by :");
		    jLabel5= new JLabel("Refresh time:");

		    jLabel3.setBounds(30, 49, 115, 20);
		    jLabel5.setBounds(25, 78, 109, 20);
		    pleft.add(jLabel3, null);
		    pleft.add(getJRadioButton(), null);
		    pleft.add(getJRadioButton1(), null);
		    pleft.add(getJRadioButton2(), null);
		    //-- management of radio buttons group
		    groupe = new ButtonGroup();
		    groupe.add(jRadioButton);
		    groupe.add(jRadioButton1);
		    groupe.add(jRadioButton2);
		    jRadioButton2.setSelected(true);
		    peerOrderOption=2;
		    //-- right part with refresh rate input field	
		    pright.add(jLabel5, null);
		    pright.add(getRefresh(), null);

		    p.setLayout(new BorderLayout(5, 5)); // hor and vert space bewtween borders 
		    p.add(BorderLayout.LINE_START,pleft);
		    p.add(BorderLayout.LINE_END,pright);
		    return(p);
	  }
	  private JPanel getJPanel() {
		    if (jPanel == null) {
				jPanel = new JPanel();
				jPanel.setLayout(new BorderLayout(5, 5)); // hor and vert space bewtween borders 

				jPanel.add(BorderLayout.NORTH,getTopPanel());
				jPanel.add(BorderLayout.CENTER,getJScrollPane());
				//--- bottom buttons : "Start log" and "Graphical view"
				jPanel.add(BorderLayout.SOUTH,getBottomButtonsPanel());
				//we set disponibility view as default
				jScrollPane.setViewportView(getJdispTable());
		    }
		    return jPanel;
	  }

	  private JButton getReloadButton() {
		    if (reloadButton == null) {
				reloadButton = new JButton();
				reloadButton.setBounds(379, 120, 218, 22);
				reloadButton.setText("Reload");
				reloadButton.setSelected(true);
				reloadButton.addActionListener(new java.awt.event.ActionListener() { 

						    public void actionPerformed( ActionEvent e ) {    
						    boolean clearCache = false; //default
						    if ((e.getModifiers() & ActionEvent.SHIFT_MASK) != 0)
						    // shift was pressed while clicking : reload
						    clearCache = true;
						    reload( clearCache ); 
						    }
				    		});
		    }
		    return reloadButton;
	  }	
	  private JButton getGraphButton() {
		    if (graphButton == null) {
				graphButton = new JButton();
				//graphButton.setBounds(383, 355, 218, 22);
				graphButton.setText("Graphical view");
				graphButton.addActionListener(new java.awt.event.ActionListener() { 
						    public void actionPerformed( ActionEvent e ) {    
						    if ( peers==null || peers.size()==0 )
						    		System.out.println("No data to display yet");
						    else
						    	if (fen==null) {
								log.debug("@ Visu_Param::graphButton pressed.");
								fen = new Fenetre( jc2,"Nodes Graph" );
							}
						    }


						    });
		    }	
		    return graphButton;

	  }

	  public void writeLog(){
		    if(IsLogging){
				log.info(((MyTableModel)jdispTable.getModel()).toString()+((taskTableModel)jtaskTable.getModel()).toString());

		    }
	  }

	  private JButton getLogButton(){
		    if(LogButton==null){
				LogButton= new JButton();
				//LogButton.setBounds(25, 355, 218, 22);
				LogButton.setText("Logger");
				LogButton.addActionListener(new java.awt.event.ActionListener() { 
						    public void actionPerformed(java.awt.event.ActionEvent e) {    
						    if(!IsLogging){
						    IsLogging=true;
						    log.info("runVisu Started Logging on user demand");
						    //writeLog();
						    LogButton.setText("Stop Logger");
						    }
						    else{
						    LogButton.setText("Logger");
						    IsLogging=false;
						    log.info("runVisu Stopped Logging on user demand");
						    }
						    }
						    });
		    }
		    return LogButton;
	  }
	  private JRadioButton getJRadioButton() {
		    if (jRadioButton == null) {
				jRadioButton = new JRadioButton();
				jRadioButton.setBounds(168, 52, 59, 16);
				jRadioButton.setText("Rank");
				jRadioButton.addItemListener(new java.awt.event.ItemListener() { 
						    public void itemStateChanged(java.awt.event.ItemEvent e) {    
						    peerOrderOption=1;
						    if (jScrollPane!=null)
						    jScrollPane.setViewportView(getJtaskTable());
						    }
						    });
		    }
		    return jRadioButton;
	  }
	  private JRadioButton getJRadioButton1() {
		    if (jRadioButton1 == null) {
				jRadioButton1 = new JRadioButton();
				jRadioButton1.setBounds(234, 48, 93, 23);
				jRadioButton1.setText("Subnet");
				jRadioButton1.addItemListener(new java.awt.event.ItemListener() { 
						    public void itemStateChanged(java.awt.event.ItemEvent e) {    
						    peerOrderOption=3;
						    }
						    });
		    }
		    return jRadioButton1;
	  }
	  private JRadioButton getJRadioButton2() {
		    if (jRadioButton2 == null) {
				jRadioButton2 = new JRadioButton();
				jRadioButton2.setBounds(324, 52, 132, 17);
				jRadioButton2.setText("disponibility");

				jRadioButton2.addItemListener(new java.awt.event.ItemListener() { 
						    public void itemStateChanged(java.awt.event.ItemEvent e) {    
						    peerOrderOption=2;
						    if (jScrollPane!=null)
						    jScrollPane.setViewportView(getJdispTable());
						    }
						    });
		    }
		    return jRadioButton2;
	  }
	  private JTextField getRefresh() {
		    if (refresh == null) {
				refresh = new JTextField();
				refresh.setBounds(186, 78, 67, 15);
				refresh.setText("30");
		    }
		    return refresh;
	  }
	  private JTable getJtaskTable() {
		    if (jtaskTable == null) {
				jtaskTable = new JTable(new taskTableModel( this ));
		    }
		    return jtaskTable;
	  }

	  private JTable getJdispTable() {
		    if (jdispTable == null) {
				log.debug("@ Visu_Param::getJdispTable()-> new JTable(new MyTableModel(this)");
				jdispTable = new JTable(new MyTableModel( this ));
		    }
		    return jdispTable;
	  }

	  private JTable getJTable(){
		    switch ( peerOrderOption ){
				case 1: {/* we must initialize the other jTable */ getJdispTable(); return getJtaskTable();}
				case 2: {getJtaskTable(); return getJdispTable();}
		    }
		    return null;
	  }
	  private JScrollPane getJScrollPane() {
		    if (jScrollPane == null) {
				jScrollPane = new JScrollPane();
				jScrollPane.setBounds(25, 146, 565, 201);
				jScrollPane.setViewportView(getJTable());
		    }
		    return jScrollPane;
	  }

	/**
	 * Hide unecessary buttons and fields (when conencted to a VisuPorxy).
 	 * Unused for now. "Reload" button should stay accessible to query peers...
	 * @author genaud
	 **/
	  public void setReloadCommandsVisible( boolean b ) {
		    this.jLabel5.setVisible( b );   // "refresh" label
		    this.refresh.setVisible( b );   // "refresh" input field
		    this.reloadButton.setVisible( b ); // "Reload" button
	  }


	/**
	 * Reload information, that is re-run the scan process.
	 * When the GUI reload button is pressed wakeup the thread that continuously 
	 * (at a given refresh rate) 
	 * 1) queries either the PeerCache, or the MPDs,
	 * 2) and refresh the GUI table display
	 * @param clearCache if true, a network query will occur, else values will be fetched in cache.
	 */
	  public void reload( boolean clearCache) {

		    log.debug("@ Visu_Param :: scan() -> clearCache="+clearCache+", textMode=" + textMode );
		    refreshDisplayThread.setClearCache( clearCache );
		    refreshDisplayThread.monitorReloadOrRefresh( 0 ); // Reload immediately

		    //((MyTableModel)jdispTable.getModel()).clear();
	  }

	  /**
	   * @author ghazi
	   **/
	  public void refreshTables(){
		    log.debug("@ Visu_Param :: refreshTable()");
		    System.out.flush();
		    ((MyTableModel)jdispTable.getModel()).fireTableDataChanged();
		    ((taskTableModel)jtaskTable.getModel()).fireTableDataChanged();
		    if ( textMode ) {
				/* //for clearing the sceen :: doesn't work :(

				   String clearScreenCommand = null;
				   String s = OsInfo.getName();
				   if( OsInfo.isWindows(s) )
				   clearScreenCommand = "cls";
				   else
				   clearScreenCommand = "clear";

				   try{
				   Runtime.getRuntime().exec( clearScreenCommand );
				   }catch(java.io.IOException e) {System.out.println("IO problem");}
				 */
				System.out.printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
				System.out.println(((MyTableModel)jdispTable.getModel()).toString());
				System.out.printf("\n\n");
				System.out.println(((taskTableModel)jtaskTable.getModel()).toString());

		    }
	  }

	  public void constructTaskData(){
		    ((taskTableModel)jtaskTable.getModel()).constructData();
	  }


}
