package p2pmpi.tools;

import p2pmpi.common.*;
import p2pmpi.message.*;
import java.util.*;
import java.net.*;
import java.io.*;

public class RSStatus {
	static public void display(String ip, Vector<JobInfo> jobList) {
		System.out.println("Job Information on : " + ip + "\n");
		System.out.println("ID\t\t\tStatus");
		if(jobList == null) {
			return;
		}
		int size = jobList.size();
		for(int i = 0; i < size; i++) {
			JobInfo job = jobList.elementAt(i);
			System.out.print(job.getHashID() + "\t\t");
			switch(job.getStatus()) {
				case JobInfo.JOB_RESERVED :
					System.out.println("reserved");
					break;
				case JobInfo.JOB_STARTING :
					System.out.println("starting");
					break;
				case JobInfo.JOB_RUNNING :
					System.out.println("running");
					break;
			}

		}

		System.out.println("\n\nTotal : " + size + " jobs.");
	}



	static public void main(String[] args) {
		String envPath = System.getProperty("P2PMPI_HOME");
		if(envPath == null) {
			System.err.println("Please make sure that the environment variable P2PMPI_HOME is set");
			System.exit(1);
		}
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		int rsPort 	= ppConf.getRSPort();
		
		Vector<JobInfo> jobList = null;

		try {
			Socket sock = new Socket(args[0], rsPort);
			InputStream in   = sock.getInputStream();
			OutputStream out = sock.getOutputStream();
			RequestJobInfoMessage requestMsg = new RequestJobInfoMessage();

			ObjectOutputStream oos = new ObjectOutputStream(out);
			oos.writeObject(requestMsg);
			oos.flush();

			ObjectInputStream ois = new ObjectInputStream(in);
			ReplyJobInfoMessage replyMsg = (ReplyJobInfoMessage)ois.readObject();
			jobList = replyMsg.getJobList();
			ois.close();
			oos.close();
			out.close();
			in.close();
			sock.close();
		} catch(Exception e) {
			System.out.println("[Error] : " + e.toString());
			System.exit(1);
		}

		RSStatus.display(args[0], jobList);
	}
}
