package p2pmpi.tools;
import p2pmpi.common.*;
import p2pmpi.message.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class MPIShutdown {
	public static void main(String[] args) {
		boolean displayMode = true;
		if(args.length != 0) {
			displayMode = false;
		}
		//read config file for MPD port
		P2PMPI_ConfigFile ppConf = new P2PMPI_ConfigFile( );
		int mpdPort = ppConf.getMPDPort();
		int ftPort  = ppConf.getFTPort();
		int fdPort  = ppConf.getFDPort();
		int rsPort  = ppConf.getRSPort();

		RequestQuitMessage quitMsg = new RequestQuitMessage();
		Socket s;
		OutputStream out;
		ObjectOutputStream oos;
		//Shut down FT service
		try {
			s = new Socket("127.0.0.1", ftPort);
			out = s.getOutputStream();
			oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			if(displayMode) {
				System.out.println("FT Shutdown ... Done.");
			}
		} catch (Exception e) {
			if(displayMode) {
				System.out.println("FT Shutdown ... No FT process at port:" + ftPort);
			}
		}

		//Shut down FD service
		try {
			s = new Socket("127.0.0.1", fdPort);
			out = s.getOutputStream();
			oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			if(displayMode) {
				System.out.println("FD Shutdown ... Done.");
			}
		} catch (Exception e) {
			if(displayMode) {
				System.out.println("FD Shutdown ... No FD process at port:" + fdPort);
			}
		}

		//Shut down RS service
		try {
			s = new Socket("127.0.0.1", rsPort);
			out = s.getOutputStream();
			oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			if(displayMode) {
				System.out.println("RS Shutdown ... Done.");
			}
		} catch (Exception e) {
			if(displayMode) {
				System.out.println("RS Shutdown ... No RS process at port:" + rsPort);
			}
		}




		// Shut down MPD service
		try {
			s = new Socket("127.0.0.1", mpdPort);
			out = s.getOutputStream();
			oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			if(displayMode) {
				System.out.println("MPD Shutdown ... Done.");
			}
		} catch (Exception e) {
			if(displayMode) {
				System.out.println("MPD Shutdown ... No MPD process at port:" + mpdPort);
			}
		}

		if(displayMode) {
			System.out.println("P2P-MPI Shutdown .. Completed");
		}

	}
}
