package p2pmpi.message;

import p2pmpi.common.*;
//import p2pmpi.mpi.internal.*;
import java.net.*;
import java.io.*;

public class MPIMessage implements Serializable {
	private static final long serialVersionUID = 2000020L;
	int cmd;
	int rank;
	int rankInList;
	int size;
	URI uri;
	RankTable comm;
	int fdPort;
	int t_gossip;
	int t_margin;
	int t_diff;
	int t_hang;
	String gossipProtocol;

	public void setGossipProtocol(String protocol) {
		gossipProtocol = new String(protocol);
	}

	public String getGossipProtocol() {
		return gossipProtocol;
	}

	public MPIMessage(int cmd) {
		this.cmd = cmd;
	}

	public void setFDPort(int fdPort) {
		this.fdPort = fdPort;
	}

	public void setTHang(int t_hang) {
		this.t_hang = t_hang;
	}
	public int getTHang() {
		return t_hang;
	}

	public void setTGossip(int t_gossip) {
		this.t_gossip = t_gossip;
	}
	public void setTMargin(int t_margin) {
		this.t_margin = t_margin;
	}
	public void setTDiff(int t_diff) {
		this.t_diff = t_diff;
	}

	public int getTDiff() {
		return t_diff;
	}

	public int getTGossip() {
		return t_gossip;
	}
	public int getTMargin() {
		return t_margin;
	}

	public int getFDPort() {
		return fdPort;
	}

	public int getCmd() {
		return cmd;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public int getSize() {
		return size;
	}

	public void setRank(int rank) {
		this.rank = rank;
	}

	public void setRankInList(int rankInList) {
		this.rankInList	= rankInList;
	}

	public int getRankInList() {
		return rankInList;
	}

	public void setURI(String hostname, int port) {
		try {
			uri = new URI("tcp://"+hostname+":"+port);
		} catch (Exception e) {
			e.printStackTrace();
			uri = null;
		}
	}

	public void setURI(URI uri) {
		this.uri = uri;
	}

	public int getRank() {
		return rank;
	}

	public URI getURI() {
		return uri;
	}

	public void setCommTable(RankTable comm) {
		this.comm = comm;
	}

	public RankTable getCommTable() {
		return comm;
	}
}
