package p2pmpi.common;

import java.io.*;
import java.net.*;
import java.util.*;

public class RankTable implements Serializable {
	private static final long serialVersionUID = 1000004L;

	Vector<TableInfo> table;
	public RankTable() {
		table = new Vector<TableInfo>();
	}

	public void addProcess(int rank, URI ipPort, int fdPort) {
		TableInfo tableInfo = new TableInfo(rank, ipPort, true, fdPort);
		table.addElement(tableInfo);
	}

	//TODO : ADD PROCESS with BOolean alive as argument
	public void addProcess(int rank, String hostname, int port, int fdPort) {
		URI uri = null;
		try {
			uri = new URI("tcp://"+hostname+":"+port);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		TableInfo tableInfo = new TableInfo(rank, uri, true, fdPort);
		table.addElement(tableInfo);
	}

	public int size() {
		return table.size();
	}

	public String getHost(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getURI().getHost();
	}

	public int getPort(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getURI().getPort();
	}

	public int getFDPort(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getFDPort();
	}

	public int getRank(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.getRank();
	}

	public boolean isAlive(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isAlive();
	}

	public boolean isTerminated(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isTerminated();
	}

	/*
	public boolean isVisible(int index) {
		TableInfo tmp = table.elementAt(index);
		return tmp.isVisible();
	}
	*/

	public void setAlive(int index, boolean alive) {
		TableInfo tmp = table.elementAt(index);
		tmp.setAlive(alive);
	}

	public void setTerminated(int index, boolean terminated) {
		TableInfo tmp = table.elementAt(index);
		tmp.setTerminated(terminated);
	}

	/*
	public void setVisible(int index, boolean visible) {
		TableInfo tmp = table.elementAt(index);
		tmp.setVisible(visible);
	}
	*/


	// Return only alive process
	public URI[] getURIs() {
		int size = size();
		URI[] result = new URI[size];
		TableInfo tmp;
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			try {
				result[i] = new URI(tmp.getURI().toString());
			} catch (Exception e) {}
		}

		return result;
	}

	public URI[] getFDURIs() {
		int size = size();
		URI[] result = new URI[size];
		TableInfo tmp;
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			try {
				result[i] = new URI(tmp.getFDURI().toString());
			} catch (Exception e) {}
		}

		return result;
	}

	public Vector<Integer> getRankInListByRank(int rank) {
		Vector<Integer> result = new Vector<Integer>();
		TableInfo tmp;
		int size = size();

		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			if(tmp.getRank() == rank) {
				if(tmp.isAlive()) {
					Integer element = new Integer(i);
					result.addElement(element);
				}
			}
		}

		return result;
	}

	public Vector<URI> getURIByRank(int rank) {
		Vector<URI> result = new Vector<URI>();
		TableInfo tmp;
		int size = size();
		for(int i = 0; i < size; i++) {
			tmp = table.elementAt(i);
			if(tmp.getRank() == rank) {
				if(tmp.isAlive()) {
					result.addElement(tmp.getURI());
				}
			}
		}
		return result;
	}

	public class TableInfo implements Serializable {
		private static final long serialVersionUID = 1000006L;
		int rank;
		URI ip;
		boolean alive;
		int fdPort;
		boolean terminated;
		//boolean visible;

		public TableInfo(int rank, URI ip, boolean alive, int fdPort) {
			this.rank 	= rank;
			this.ip		= ip;
			this.alive	= alive;
			this.terminated = false;
			this.fdPort	= fdPort;
			//this.visible	= true;
		}

		public void setAlive(boolean alive) {
			this.alive 	= alive;
		}

		public void setTerminated(boolean terminated) {
			this.terminated = terminated;
		}

		public void setFDPort(int fdPort) {
			this.fdPort = fdPort;
		}

		public int getFDPort() {
			return fdPort;
		}

		public URI getFDURI() {
			URI result = null;
			try {
				result = new URI("tcp://"+ip.getHost()+":"+fdPort);
			} catch (Exception e) {
				e.printStackTrace();
			}
			return result;
		}

		/*
		public void setVisible(boolean visible) {
			this.visible = visible;
		}
		*/

		public boolean isAlive() {
			return alive;
		}

		public boolean isTerminated() {
			return terminated;
		}

		public URI getURI() {
			return ip;
		}

		public int getRank() {
			return rank;
		}

		/*
		public boolean isVisible() {
			return visible;
		}
		*/
	}
	
}
