package p2pmpi.common;

import java.io.*;
import java.net.*;

public class ProcessInfo implements Serializable {
	private static final long serialVersionUID = 1000005L;
	String id;
	String runCmd;
	String ipRank0;
	String runDir;
	int myRank;
	int myPort;
	int mpiSize;
	int realSize;
	RankTable rankTable;

	public ProcessInfo() {
		rankTable = null;
	}

	public void setRankTable(RankTable rankTable) {
		this.rankTable = rankTable;
	}

	public RankTable getRankTable() {
		return rankTable;
	}

	public void setID(String id) {
		this.id = id;
	}

	public String getID() {
		return id;
	}

	public void setRunCmd(String runCmd) {
		this.runCmd = runCmd;
	}

	public String getRunCmd() {
		return runCmd;
	}

	public void setIPRank0(String ipRank0) {
		this.ipRank0 = ipRank0;
	}

	public String getIpRank0() {
		return ipRank0;
	}

	public void setRunDir(String runDir) {
		this.runDir = runDir;
	}

	public String getRunDir() {
		return runDir;
	}

	public void setRank(int myRank) {
		this.myRank = myRank;
	}

	public int getRank() {
		return myRank;
	}

	public void setPort(int myPort) {
		this.myPort = myPort;
	}

	public int getPort() {
		return myPort;
	}

	public void setMPISize(int mpiSize) {
		this.mpiSize = mpiSize;
	}

	public int getMPISize() {
		return mpiSize;
	}

	public void setRealSize(int realSize) {
		this.realSize = realSize;
	}

	public int getRealSize() {
		return realSize;
	}

	public void displayInfo() {
		System.out.println("ID = " + id);
		System.out.println("RunCMD = " + runCmd);
		System.out.println("IP rank0 = " + ipRank0);
		System.out.println("RunDir = " + runDir);
		System.out.println("MyRank = " + myRank);
		System.out.println("MyPort = " + myPort);
		System.out.println("MPI  Size = " + mpiSize);
		System.out.println("Real Size = " + realSize);
		int size = rankTable.size();
		for(int i = 0; i < size; i++) {
			System.out.println("Rank:"+rankTable.getRank(i)+","+rankTable.getHost(i)+":"+rankTable.getPort(i)+",alive="+rankTable.isAlive(i));
		}
	}
}
