package p2pmpi.visu;
import java.util.*;
import javax.swing.JTable;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;


class taskTableModel extends AbstractTableModel {
	private String[] columnNames = {
		"RunCmd",
		"Rank",
		"Name",
		"Status"};
			
			
	Visu_Param parent;
	private Vector<taskObject> data;
	int nbReplicasTreated;
		
	public taskTableModel(Visu_Param parent){
		this.parent=parent;	
		data=new Vector();
	}
		
	class taskObject{
		public String runCmd;
		public int Rank;
		public String Name;
		public Integer Status;
		
		public taskObject(String cmd, int r, String n, Integer s){
			runCmd=cmd;
			Rank=r;
			Name=n;
			Status=s;
		}
	}
			
			
	public int getColumnCount() {
		return columnNames.length;
	}

	public int getRowCount() {
		if(data.size()==0)
			return 1;
		return data.size();
	}
		
	public String getColumnName(int col) {
		return columnNames[col];
	}
		
	public void constructData(){
		int i,j,k,l;
		Vector<String> treatedTasks=new Vector();
		data.clear();
		for(i=0;i<parent.peers.size();i++){
			PeerNode p =  (PeerNode) parent.peers.get(i);
			for(j=0;j<p.Tasks.size();j++){  //if the Peer has a Task
				 if(!treatedTasks.contains(	p.Tasks.get(j).getCmd()))
					for(k=0;k<p.Tasks.get(j).getRanks().size();k++) // we look for the First Rank O
					{									 
						if(((Integer)p.Tasks.get(j).getRank(k)).intValue()==0) { 
							//we add this peer to the data vector and look for the rest of ranks
							taskObject t = new taskObject(p.Tasks.get(j).getCmd(), 0, p.getHostName(), (Integer)p.Tasks.get(j).getRankStatus(0));
							data.addElement(t);
							for(l=1;l<p.Tasks.get(j).getTotalNbRanks();l++)
								for(int m=0;m<p.Tasks.get(j).getNbReplicas();m++){
									data.addElement(find(p.Tasks.get(j).getCmd(),l,m));
								}
							treatedTasks.addElement(p.Tasks.get(j).getCmd());
						}
					}
				}
			}
			fireTableRowsInserted(0,data.size());
		}
		
		
		public Object getValueAt(int row, int col) {
			if(data.size()>row) {
				try{
				switch(col){
				  case 0: return ((taskObject)data.get(row)).runCmd;
				  case 1: return ((taskObject)data.get(row)).Rank;
				  case 2: return ((taskObject)data.get(row)).Name;
				  case 3: if (((taskObject)data.get(row)).Status.intValue()==1 ) return "Alive";
				 }
			 }catch(Exception e) {}
			}
			else 
				return "";
				
			return "";
			
		}
		
	public String toString(){
		String result="\n\n** Task Table **\n\n==================================================\n";
		result=result+"RunCmd\tRank\tName\t\t\tStatus";
		result=result+"\n_____________________________________________________\n";
		int i,j;
		for(i=0;i<getRowCount();i++) {	
			result=result+"\n";
			for(j=0;j<getColumnCount();j++)
				result=result+getValueAt(i,j)+"\t";
		}
		return result;
	}
		
	private taskObject find(String neededTask, int neededRank,  int neededReplica){
		int i,j,k;
		int numReplica=0;
		for(i=0;i<parent.peers.size();i++){
			PeerNode p =  (PeerNode) parent.peers.get(i);
			for(j=0;j<p.Tasks.size();j++){
				Task t = (Task) p.Tasks.get(j);
							
			if(t.getCmd()==neededTask){
				//we look for the Rank
				for(k=0;k<t.getRanks().size();k++) {
					boolean b= ((Integer)t.getRank(k)).intValue()==neededRank && numReplica==neededReplica;
					if(((Integer)t.getRank(k)).intValue()==neededRank){//we have our peer
						if(numReplica==neededReplica){ 	
							int Rank = t.getRank(k);
							Integer status = t.getRankStatus(k);
							String cmd = t.getCmd();
							String Name = p.getHostName();
							return new taskObject(cmd,Rank,Name,status);
						}
						else 
							numReplica++;
						}
					}
				}
						}
			}	
			return null;
	}
				
			
	public void clear() {
		data.clear();
	}
}
