package p2pmpi.visu;


import p2pmpi.p2p.message.*;
import p2pmpi.common.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class StopVisuProxy {

	private static final String portPropName = "VisuProxyListenPort"; // 
	private static final String conffileName = "P2P-RDV.conf"; // 
	public static void main(String[] args) {
		//read config file for internal RDV port
		File configFile = new File(System.getProperty("P2PMPI_HOME"), conffileName );
		GenericConfigFile conf = new GenericConfigFile(configFile.toString());
		String portConf = conf.getProperty( portPropName );
		if (portConf == null) { 
			System.err.println("[Error] can not find a valid port under property \""+portPropName+"\" in configuration file "+conffileName+". Exiting."); 
			System.exit( 1 );
		}
		int visuProxyListenPort = Integer.parseInt( portConf );
		try {
			QuitMessage quitMsg = new QuitMessage( InetAddress.getLocalHost() );
			Socket s = new Socket("127.0.0.1", visuProxyListenPort);
			OutputStream out = s.getOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(out);
			oos.writeObject(quitMsg);
			oos.flush();
			oos.close();
			out.close();
			s.close();
			System.out.println("VisuProxy shutdown ... done.");
		} catch (Exception e) {
			System.out.println("No VisuProxy process is running at port:" + visuProxyListenPort);
			//e.printStackTrace();
		}
	}
}
