/*
 * ProxyNotificationListener  : part of P2P-MPI (http://www.p2pmpi.org).
 *
 * Copyright (C) 2007, Stephane Genaud and Choopan Rattanapoka 
 *
 * This tool is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
    ProxyNotificationListener is a thread listening to UpdateListMessages
    from VisuProxy. When such a message arrives, it updates the peerList
    of the parent StatQuery.

   SuperNode stores information about hosts running MPD.
   It is a simple replacement to the JXTA SRDI previously used.
   Information is a list of 'HostEntry':
   HostEntry(String ip, int mpdPort, int fdPort, int ftPort, int rsPort, int numProcPerJob)

   @author Stephane Genaud, creation wen aug 3, 2007, 11:11:34 (UTC+0200)
 */


package p2pmpi.visu;

import p2pmpi.common.*;
import p2pmpi.message.*;
import p2pmpi.p2p.message.*;   // use RegisterMessage.class
import p2pmpi.tools.SupernodeHostCacheDisplay;
import java.util.*;
import java.net.*;
import java.io.*;

public class ProxyNotificationListener extends Thread {

	  private static int listenPort;
	  private static ServerSocket listenServerSocket;
	  protected StatQuery attachedQuery;   // the StatQuery which we work for  

	  /**
	   * Constructor.
	   * Assume 'listenServerSocket' is already bound at this stage.
	   **/
	  public ProxyNotificationListener ( StatQuery q, ServerSocket listenServerSocket ) {
		this.attachedQuery = q; 
		this.listenServerSocket = listenServerSocket;
		this.listenPort = listenServerSocket.getLocalPort();
	  }

	  /**
	   *  listening thread.
	   *  Listen to incoming notification. 
	   *  ServerSocket 'listenServerSocket' is assumed to be already bound at this stage.
	   **/
	  public void run() {

		     System.out.println("Thread Listening on port " + listenPort);
		    // ---- permanently listen to notifications
		    while(true) {
				try {
					  Socket conn = listenServerSocket.accept();
					  ProcessThread t = new ProcessThread( listenServerSocket, conn );
					  t.start();
				} catch (Exception e) { break; }
		    }

		    try {
				listenServerSocket.close();
		    } catch (Exception e) {e.printStackTrace();}

		    System.exit( 1 ); 
	  }



	  //-------------------- C O N N E C T I O N   H A N D L I N G   T H R E A D ---------------------------


	  public class ProcessThread extends Thread {
		    ServerSocket serverSocket = null;
		    Socket socket = null;

		    ProcessThread( ServerSocket serverSocket, Socket socket ) {
				this.serverSocket = serverSocket;
				this.socket       = socket;
		    }

		    /**
		     * Thread handling connections.
		     * Wait for register/unregister messages from clients, and send notifications
		     * when changes occurs in SuperNode tables.
		     **/
		    public void run( ) {
				InputStream in = null;
				ObjectInputStream ois = null;
				ObjectOutputStream oos = null;
				Object inMsg;
				HostEntry host;

				try {
					  in = socket.getInputStream();
					  ois = new ObjectInputStream(in);
					  inMsg = ois.readObject();
				} catch (Exception e) {
					  return;
				}
				if ( inMsg instanceof UpdateListMessage ) {
					  Vector<HostEntry> hostList = ((UpdateListMessage)inMsg).getHostList();
					  //System.out.println("[Notification Listener] hostList received"); 
					  attachedQuery.setPeerList( hostList );
				}
				else
					  System.err.println("[Notification Listener] unknown message type received. Ignoring."); 
		    }

	  }

}
