/*
 * TouchGraph LLC. Apache-Style Software License
 *
 *
 * Copyright (c) 2002 Alexander Shapiro. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment: 
 *       "This product includes software developed by 
 *        TouchGraph LLC (http://www.touchgraph.com/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "TouchGraph" or "TouchGraph LLC" must not be used to endorse 
 *    or promote products derived from this software without prior written 
 *    permission.  For written permission, please contact 
 *    alex@touchgraph.com
 *
 * 5. Products derived from this software may not be called "TouchGraph",
 *    nor may "TouchGraph" appear in their name, without prior written
 *    permission of alex@touchgraph.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL TOUCHGRAPH OR ITS CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 */


package p2pmpi.visu;

import p2pmpi.common.*;
import com.touchgraph.graphlayout.*;
import java.util.Vector;
import java.awt.*;
import java.io.*;
import java.awt.Image;

public class PeerNode extends com.touchgraph.graphlayout.Node {

    public static Font HINT_FONT = new Font("Courier",Font.PLAIN,11);
    public static Color HINT_BACK_COLOR = Color.darkGray;
    public static Color HINT_TEXT_COLOR = Color.white;
    public static int MINIMUM_HINT_HEIGHT = 20;
    
    String hint;
    boolean hintIsHTML=false;
    int hintWidth = 200;
    int hintHeight = -1; //A value of less then MINIMUM_HINT_HEIGHT means that the hint height 
                         //is automatically determined
    Font hintFont;
    
	String name;
	String hostName="wait";
	String ip="wait";
	String domainName="wait";
	String cpu="";
	String cpuFreq="";
	String mem="";
	String osName="wait";
	String arch="";
	String status="wait";
	
	public Vector<Task> Tasks;

	Visu_Param parent;

	public String getCpu(){ return cpu; }
	public String getCpuFreq(){ return cpuFreq; }
	public String getMem(){ return mem; }
	public String getHostName(){ return hostName; }
	public String getDomainName(){ return domainName; }
	public String getIp(){ return ip; }
	public String getName(){ return name; }
	public String getOsName(){ return osName; }
	public String getArch(){ return arch; }
	public String getStatus(){ return status; }

	public void setCpu( String s )          { cpu = s; }
	public void setCpuFreq( String s )      { cpuFreq = s; }
	public void setMem(String s )           { mem = s; }
	public void setDomainName( String s )   { domainName = s; }
	public void setName( String s )         { name = s; }
	public void setHostName( String s )     { hostName= s; }
	public void setIP( String s )           { this.ip = s; }
	public void setOsName( String s )       { 
		this.osName = s; // update internal record Image img=null;
		Image img = null;
		try {
		    img = parent.jc2.getToolkit().getImage(System.getProperty("P2PMPI_HOME")+
					  "/icons/"+OsInfo.normalizedOsInfo(this.osName)+".png");
		} catch(Exception e){ 
		System.out.println("Problem opening icon Image"); 
		e.printStackTrace();
		}
		setImage(img);
	}
	public void setArch( String s )         { arch = s; }
	public void setStatus( String s )       { status = s; }

	public void setProperties( String hostname, String ip, String domainName, String cpu, String cpuFreq, String mem, String osName, String arch) {
			  this.hostName=hostname;
			  this.ip=ip;
			  this.domainName = domainName; 
			  this.cpu = cpu;
			  this.cpuFreq = cpuFreq;
			  this.mem = mem;
			  setOsName( osName );
			  this.arch = arch;
	}


	public void newTask(String runCmd, int rank, boolean status, int totalNbRanks, int nbReplicas ){
		  Task t= new Task(runCmd,rank,status,totalNbRanks,nbReplicas);
		  Tasks.addElement(t);
	}

	public PeerNode(String id, String l) {
		  super(id, l);
		  hint = "";
		  hintFont = HINT_FONT;
	}

	public PeerNode(String id, String l, Visu_Param parent /*, String u*/) {
		  super(id, l);
		  //   url = u;
		  hint = "";
		  hintFont = HINT_FONT;
		  this.parent=parent;
		  Tasks = new Vector<Task>();
	}

	public void setNodeHintFont( Font font ) { HINT_FONT = font; }
	public void setNodeHintBackColor( Color color ) { HINT_BACK_COLOR = color; }
	public void setNodeHintTextColor( Color color ) { HINT_TEXT_COLOR = color; }

	public void setHint(String h) {
		  hint = h;
	}

	public String getHint() {
		  hint="IP: "+ this.ip +
			    "\nOS: "+ this.osName +
			    "\narch: "+ this.arch +
			    "\nMemory Size: "+ this.mem +
			    "\nCpu: "+ this.cpu + " Freq: "+ this.cpuFreq;

		  if( this.status=="Working"){
			    if(parent.currentTask!=null&&parent.currentTask!="Disponibility")
			    {
					//we must find the ranks of the peer in this task
					boolean found=false;
					int i=0;
					while(i<Tasks.size()&& !found){
						  if(Tasks.get(i).getCmd()==parent.currentTask){
							    hint=hint+"\nRanks: ";
							    found=true;
							    for(int j=0;j<Tasks.get(i).getRanks().size();j++){
									int rank=((Integer)Tasks.get(i).getRank(j)).intValue();
										  hint=hint+rank+", ";
							    }
						  }	
						  i++;
					}
			    }
			    else{
					hint=hint+"\nTasks: ";
					for(int i=0;i<Tasks.size();i++)
						  hint=hint+Tasks.get(i).getCmd()+", ";
			    }
		  }	
		  return hint;
	}

	public void setHintIsHTML(boolean hih) { hintIsHTML = hih; }
	public boolean getHintIsHTML() { return hintIsHTML; }
	public void setHintWidth(int hw) { hintWidth = hw; }
	public int getHintWidth() { return hintWidth; } 
	public void setHintHeight(int hh) { hintHeight = hh; }
	public int getHintHeight() { return hintHeight; }
	public int getWidth() {
		  if(fontMetrics!=null && lbl!=null) {
			    if(typ!=TYPE_ELLIPSE) 
					return fontMetrics.stringWidth(lbl) + 8;
			    else
					return fontMetrics.stringWidth(lbl) + 28;
		  }
		  else
			    return 8;
	}

	public int getHeight() {
		  if (fontMetrics!=null) 
			    return fontMetrics.getHeight()+2;
		  else 
			    return 8; 
	}
	Color myBrighter(Color c) {
		  int r = c.getRed();
		  int g = c.getGreen();
		  int b = c.getBlue();

		  if(b>r+64&&b>g+64) {r+=32;g+=32;} 

		  r=Math.min(r+144, 255);
		  g=Math.min(g+144, 255);
		  b=Math.min(b+144, 255);

		  return new Color(r,g,b);   
	}

	public void paint( Graphics g, TGPanel tgPanel ) {
		  if(status == "Working") { 
			    if(parent.currentTask!=null && parent.currentTask!="Disponibility"){//we must look if the peer has this task
					boolean found=false;
						  int i=0;
						  while(i<Tasks.size()&& !found){
							    if(Tasks.get(i).getCmd()==parent.currentTask)
									found=true;
							    int rank=((Integer)Tasks.get(i).getRank(0)).intValue();
									setBackColor(new Color(10,  Math.min(60*rank+60, 255),10));
									i++;
						  }

					if(!found)
						  setBackColor(Color.decode("#4080A0"));	
			    }
			    else //there is no current Task set, so we show a working peer
					setBackColor(new Color(225, 164, 0) );

		  }
		  else 
			    if (status == "Scanning...")
					setBackColor(Color.RED);
			    else
					if(getType()!=TYPE_ELLIPSE)
						  setBackColor(Color.decode("#4080A0"));
		  super.paint(g,tgPanel);
	}
}
