package p2pmpi.visu;
import java.util.*;
import javax.swing.JTable;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import javax.swing.table.AbstractTableModel;


class MyTableModel extends AbstractTableModel {
	
	private String[] columnNames = {"Name","IP","OS","Domain","Task","Status"};
	private Vector data;

	public MyTableModel( Visu_Param parent ){
		  data = parent.peers;
	}

	public int getColumnCount() {
		  return columnNames.length;
	}

	public int getRowCount() {
		  return data.size();
	}

	public String getColumnName(int col) {
		  return columnNames[col];
	}

	public Object getValueAt(int row, int col) {
		  PeerNode p =  (PeerNode) data.get(row);
		  switch(col){
			    case 0:{ 	
						 String hostName=p.getHostName();
						 String hName;
						 int indx = hostName.indexOf(".");
						 if(indx>0 && indx<hostName.length())
							   hName=hostName.substring(0,indx);
						 else
							   hName=hostName;
						 return hName;
				     }
			    case 1: return p.getIp();
			    case 2: return p.getOsName();
			    case 3: return p.getDomainName();
			    case 4:
					{ if(p.Tasks.size()==0)
						  return "None";
						  else{
							    String taskList ="";
							    int i;
							    for(i=0;i<p.Tasks.size();i++)
									taskList = ((Task)p.Tasks.get(i)).getCmd() +", "+taskList;
							    return taskList;
						  }	
					}
			    case 5: return p.getStatus();
		  }
		  return "null";
	}

	public String toString(){
		  String result="\n\n** Disponibility Table **\n\n=========================================================================================\n";
		  result=result+"Name\t\tIP\t\tOS\tDomain\t\tTask\tStatus";
		  result=result+"\n___________________________________________________________________________________________\n";
		  int i,j;
		  for(i=0;i<getRowCount();i++)
		  {	
			    result=result+"\n";
			    for(j=0;j<getColumnCount();j++)
					if(j==0 && ((String) getValueAt(i,j)).length()<8)
						  result=result+getValueAt(i,j)+"     \t";
					else
						  result=result+getValueAt(i,j)+"\t";

		  }
		  return result;
	}

	public void clear() {
		  System.out.println("MyTableModel :: clear() ");
		  int numRows=data.size();
		  data.removeAllElements();
		  fireTableRowsUpdated(0, numRows - 1);
	}				
}
