import p2pmpi.mpi.*;

public class TestSendRecv {
	public static void main(String[] args) {
		MPI.Init(args);
		int rank = MPI.COMM_WORLD.Rank();
		int size = MPI.COMM_WORLD.Size();
		if(size != 2) {
			System.out.println("Run only with 2 processes");
			MPI.Finalize();
			System.exit(1);
		}
		int MAXBUF = 8;
		int TAG = 1;
		int[] sendBuf = new int[MAXBUF];
		int[] recvBuf = new int[MAXBUF];

		//Test Send and Receive message of same size
		if(rank == 0) {
			//Clear recvBuf
			for(int i = 0; i < MAXBUF; i++) {
				recvBuf[i] = 0;
			}
			MPI.COMM_WORLD.Recv(recvBuf, 0, MAXBUF, MPI.INT, 1, TAG);
			System.out.println("SendCount = RecvCount");
			System.out.println("RecvData = ");
			for(int i = 0; i < MAXBUF; i++) {
				System.out.printf("%4d", recvBuf[i]);
			}
			System.out.println("");

		} else {
			//Set sendBuf
			for(int i = 0; i < MAXBUF; i++) {
				sendBuf[i] = i;
			}
			MPI.COMM_WORLD.Send(sendBuf, 0, MAXBUF, MPI.INT, 0, TAG);
		}

		//Test Send message is smaller than Receive message
		if(rank == 0) {
			//Clear recvBuf
			for(int i = 0; i < MAXBUF; i++) {
				recvBuf[i] = 0;
			}
			MPI.COMM_WORLD.Recv(recvBuf, 0, MAXBUF, MPI.INT, 1, TAG);
			System.out.println("SendCount("+MAXBUF+") < RecvCount("+(MAXBUF/2)+")");
			System.out.println("RecvData = ");
			for(int i = 0; i < MAXBUF; i++) {
				System.out.printf("%4d", recvBuf[i]);
			}
			System.out.println("");

		} else {
			//Set sendBuf
			for(int i = 0; i < MAXBUF; i++) {
				sendBuf[i] = i;
			}
			MPI.COMM_WORLD.Send(sendBuf, 0, MAXBUF/2, MPI.INT, 0, TAG);
		}

		//Test Send message is bigger than Receive message
		if(rank == 0) {
			//Clear recvBuf
			for(int i = 0; i < MAXBUF; i++) {
				recvBuf[i] = 0;
			}
			MPI.COMM_WORLD.Recv(recvBuf, 0, MAXBUF/2, MPI.INT, 1, TAG);
			System.out.println("SendCount("+MAXBUF+") < RecvCount("+(MAXBUF/2)+")");
			System.out.println("RecvData = ");
			for(int i = 0; i < MAXBUF; i++) {
				System.out.printf("%4d", recvBuf[i]);
			}
			System.out.println("");

		} else {
			//Set sendBuf
			for(int i = 0; i < MAXBUF; i++) {
				sendBuf[i] = i;
			}
			MPI.COMM_WORLD.Send(sendBuf, 0, MAXBUF, MPI.INT, 0, TAG);
		}




		MPI.Finalize();
	}
}
