import p2pmpi.mpi.*;
import java.io.*;

public class AlltoAll {
	public static void main(String[] args) {
		MPI.Init(args);

		int size = MPI.COMM_WORLD.Size();
		int rank = MPI.COMM_WORLD.Rank();
	
		byte[] sendtable;
		byte[] recvtable;
		double[] mytimeusage = new double[1];
		double[] maxtimeusage = new double[1];

		for(int BASESIZE = 2; BASESIZE < 2000000; BASESIZE*=2) {


		int tablesize = BASESIZE * size;	
		sendtable = new byte[tablesize];
		recvtable = new byte[tablesize];

		for(int i = 0; i < tablesize; i++) {
			sendtable[i] = (byte)rank;
			recvtable[i] = 0;
		}





		double startTime = MPI.Wtime();
		MPI.COMM_WORLD.Alltoall(sendtable, 0, BASESIZE, MPI.BYTE, recvtable, 0, BASESIZE, MPI.BYTE);
		double stopTime = MPI.Wtime();
		mytimeusage[0] = stopTime - startTime;
		MPI.COMM_WORLD.Reduce(mytimeusage, 0, maxtimeusage, 0, 1, MPI.DOUBLE, MPI.MAX, 0);
		if(rank == 0)
			System.out.println("" + BASESIZE + "\t\t" + (maxtimeusage[0]/1000.0));

		/////////////////// AlltoallPairWiseSyn ////////////////////
		/*
		startTime = MPI.Wtime();
		MPI.COMM_WORLD.AlltoallPairWiseSyn(sendtable, 0, BASESIZE, MPI.INT, recvtable, 0, BASESIZE, MPI.INT);
		stopTime = MPI.Wtime();
	
		mytimeusage[0] = stopTime - startTime;
		MPI.COMM_WORLD.Reduce(mytimeusage, 0, maxtimeusage, 0, 1, MPI.DOUBLE, MPI.MAX, 0);
		if(rank == 0)
			System.out.println("Size:" + BASESIZE + ">Max AlltoallPairWiseSyn time usage = " + (maxtimeusage[0]/1000.0));

		/////////////////// AlltoallPairWiseASyn ////////////////////
		startTime = MPI.Wtime();
		MPI.COMM_WORLD.AlltoallPairWiseAsyn(sendtable, 0, BASESIZE, MPI.INT, recvtable, 0, BASESIZE, MPI.INT);
		stopTime = MPI.Wtime();
	
		mytimeusage[0] = stopTime - startTime;
		MPI.COMM_WORLD.Reduce(mytimeusage, 0, maxtimeusage, 0, 1, MPI.DOUBLE, MPI.MAX, 0);
		if(rank == 0)
			System.out.println("Size:" + BASESIZE + ">Max AlltoallPairWiseASyn time usage = " + (maxtimeusage[0]/1000.0));


		//////////////////////// Alltoallv test////////////////////////////////////
		int[] sdispl = new int[size];
		int[] rdispl = new int[size];
		int[] scount = new int[size];
		int[] rcount = new int[size];
		for(int i = 0; i < size; i++) {
			sdispl[i] = BASESIZE * i;
			rdispl[i] = BASESIZE * i;
			scount[i] = BASESIZE;
			rcount[i] = BASESIZE;
		}
		//clear recv buff
		for(int i = 0; i < tablesize; i++) 
			recvtable[i] = 0;

		startTime = MPI.Wtime();
		MPI.COMM_WORLD.Alltoallv(sendtable, 0, scount, sdispl, MPI.INT, recvtable, 0, rcount, rdispl,MPI.INT);
		stopTime = MPI.Wtime();
		mytimeusage[0] = stopTime - startTime;
		MPI.COMM_WORLD.Reduce(mytimeusage, 0, maxtimeusage, 0, 1, MPI.DOUBLE, MPI.MAX, 0);
		if(rank == 0)
			System.out.println("Size:"+ BASESIZE+ ">Max Alltoallv time usage = " + (maxtimeusage[0]/1000.0));
		*/
		}
		MPI.Finalize();
	}
}
