import p2pmpi.mpi.*;

public class SendRecv {
	public static void main(String[] args) 
	{
		MPI.Init(args);
		int rank = MPI.COMM_WORLD.Rank();
		int size = MPI.COMM_WORLD.Size();

		int[][] sendData = new int[1][1];
		int[][] recvData = new int[1][1];
		int TAG = 1;

		sendData[0][0] = rank;
	
		int source;	
		if(rank == 0) {
			source = size - 1;
		} else {
			source = rank - 1;
		}
		MPI.COMM_WORLD.Sendrecv(sendData[0], 0, 1, MPI.INT, (rank+1)%size, TAG,
				        recvData[0], 0, 1, MPI.INT, source, TAG);

		System.out.println("Rank = " + rank + ": got data = " + recvData[0][0]);
		MPI.Finalize();
	}
}
