package p2pmpi.p2p;

import java.io.*;
import java.net.*;
import p2pmpi.message.*;
import org.apache.log4j.*;

public class PingRTT {
	String destIP;
	int destPort;

	public PingRTT(String destIP, int destPort) {
		this.destIP   = destIP;
		this.destPort = destPort;
	}

	public int ping() {
		PingRequestMessage msgRequest = new PingRequestMessage();
		int numtry = 10;
		while(numtry-- >= 0) {
		   try {
			long startTime = System.currentTimeMillis();
			Socket socket = new Socket(destIP, destPort);
			OutputStream os = socket.getOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(os);
			oos.writeObject(msgRequest);
			oos.flush();

			InputStream is  = socket.getInputStream();
			ObjectInputStream ois = new ObjectInputStream(is);
			Object msgReply = ois.readObject();
			if(msgReply instanceof PingReplyMessage) {

				long stopTime = System.currentTimeMillis();
				oos.close();
				ois.close();
				os.close();
				is.close();
				socket.close();
				return (int)(stopTime - startTime);
	
			} else {
				oos.close();
				ois.close();
				os.close();
				is.close();
				socket.close();
			}
		   } catch (Exception e) {
			   //may be Dead node
		   	try {
				   Thread.sleep(1000);
		   	} catch(Exception ee) {}
	
		        continue;
		   }
		}
		return Integer.MAX_VALUE;
	}
}
