package p2pmpi.mpi;

/**
 * MPI Collective Operation
 */ 
public class Op {
	/**
	 * No operation
	 */
	public final static int NULL  = 0;

	/**
	 * Maximum operation
	 */
	public final static int MAX   = 1;

	/**
	 * Minimum operation
	 */
	public final static int MIN   = 2;

	/**
	 * Summation operation
	 */
	public final static int SUM   = 3;

	/**
	 * Multiplication operation
	 */
	public final static int PROD  = 4;

	/**
	 * Bit-wise AND operation
	 */
	public final static int BAND  = 6;

	/* TODO
	public final static int LAND  = 5;
	public final static int LOR   = 7;
	public final static int BOR   = 8;
	public final static int LXOR  = 9;
	public final static int BXOR  =10;
	*/
	public final static int MINLOC=11;
	public final static int MAXLOC=12;
  
	private MPI_User_function func = null;
	private boolean commute = false;

	/**
	 * Default constructor for MPI (internal use)
	 *
	 * @param Type		NULL, MAX, MIN, SUM, or PRUD operation
	 */
	public Op(int Type) { 
		switch(Type) {
			case NULL: 
				func = new OpNull();
				commute = true;
				break;
			case MAX:
				func = new OpMax();
				commute = true;
				break;
			case MIN:
				func = new OpMin();
				commute = true;
				break;
			case SUM:
				func = new OpSum();
				commute = true;
				break;
			case PROD:
				func = new OpProd();
				commute = true;
				break;
			case BAND:
				func = new OpBAND();
				commute = true;
				break;
			case MAXLOC:
				func = new OpMAXLOC();
				commute = true;
				break;
			case MINLOC:
				func = new OpMINLOC();
				commute = true;
				break;
			// To DO More
			default :
				func = new OpNull();
				commute = true;
				break;
		}
	  
	  
	}

	/**
	 * Constructor for the user-definition operation
	 *
	 * @param func		user-define function inherited from MPI_User_function
	 * @param commute	commutation operation
	 */
	public Op(MPI_User_function func, boolean commute) {
		this.func 	= func;
		this.commute 	= commute; //Commute False = A op B is not the same as B op A
	}

	///////////////////
	// Internal use
	///////////////////
	/**
	 * Invoke operation (internal use)
	 * @param in		Input object
	 * @param inOffset	Input offset
	 * @param inout		Input and Output object
	 * @param inoutOffset	Input and output offset
	 * @param count		number of elements
	 * @param type		MPI datatype
	 */
	public void Call(Object in, int inOffset, Object inout, int inoutOffset,
		    int count, Datatype type) {
		func.Call(in, inOffset, inout, inoutOffset, count, type);
	}

	/**
	 * Check if operation is commutative
	 *
	 * @return true if commutative, otherwise false
	 */
	public boolean isCommute() {
		return commute;
	}

	/*
	static public void main(String[] args) {
		int x1[] = {1,2,4,6,2,1,6,7};
		int y1[] = {3,1,6,2,4,8,3,5};
		int count = x1.length;

		System.out.println("===Before Call Operation===");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x1[i] + " , ");
		}
		System.out.println(" }");

		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y1[i] + " , ");
		}
		System.out.println(" }");

		// MAX OP
		///////////////////
		Op myOp = new Op(Op.MAX);
		myOp.Call(x1, 0, y1, 0, count, new Datatype(Datatype.INT));

		System.out.println("===After Call Operation (MAX)===");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x1[i] + " , ");
		}
		System.out.println(" }");
		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y1[i] + " , ");
		}
		System.out.println(" }");


		// MIN OP
		//////////////////
		int x2[] = {1,2,4,6,2,1,6,7};
		int y2[] = {3,1,6,2,4,8,3,5};
		myOp = new Op(Op.MIN);
		myOp.Call(x2, 0, y2, 0, count, new Datatype(Datatype.INT));
		System.out.println("===After Call Operation (MIN)===");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x2[i] + " , ");
		}
		System.out.println(" }");
		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y2[i] + " , ");
		}
		System.out.println(" }");

		// SUM OP
		//////////////////
		int x3[] = {1,2,4,6,2,1,6,7};
		int y3[] = {3,1,6,2,4,8,3,5};
		myOp = new Op(Op.SUM);
		myOp.Call(x3, 0, y3, 0, count, new Datatype(Datatype.INT));
		System.out.println("===After Call Operation (SUM)===");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x3[i] + " , ");
		}
		System.out.println(" }");
		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y3[i] + " , ");
		}
		System.out.println(" }");

		// PROD OP
		//////////////////
		int x4[] = {1,2,4,6,2,1,6,7};
		int y4[] = {3,1,6,2,4,8,3,5};
		myOp = new Op(Op.SUM);
		myOp.Call(x4, 0, y4, 0, count, new Datatype(Datatype.INT));
		System.out.println("===After Call Operation (PROD)===");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x4[i] + " , ");
		}
		System.out.println(" }");
		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y4[i] + " , ");
		}
		System.out.println(" }");


		// OFFSET Test
		//////////////////
		int x5[] = {1,2,4,6,2,1,6,7};
		int y5[] = {3,1,6,2,4,8,3,5};
		myOp = new Op(Op.SUM);
		myOp.Call(x5, 1, y5, 2, 3, new Datatype(Datatype.INT));
		System.out.println("==Offset Test: Start withX[1]+Y[2] for 3 elements==");
		System.out.print("X = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(x5[i] + " , ");
		}
		System.out.println(" }");
		System.out.print("Y = { ");
		for(int i = 0; i < count; i++) {
			System.out.print(y5[i] + " , ");
		}
		System.out.println(" }");
	}
	*/
}

