package p2pmpi.mpd;

import p2pmpi.common.*;

import java.io.*;
import java.net.*;
/**
 * @author choopan, genaud
 *
 */


import java.util.*;
import p2pmpi.p2p.message.*;
import p2pmpi.p2p.*;

import org.apache.log4j.*;


public abstract class P2PMPI_MPDPeer extends Thread {

    protected HostEntry myHost;
    protected int numProcPerJob;
    protected String tmpDir = null;
    protected File runPath  = null;
    protected String peerCacheFile = null;
    protected int ftPort;
    protected int fdPort;
    protected int mpdPort;
    protected int rsPort;

    protected String externalIP;
    protected String usingIP;

    protected static Logger log;

    protected String peerName = null;
    protected int processID;
    protected Timer peerDiscovery = null;

    protected final int connectNumTry = 240;
    protected final int connectSleep  = 1000;

    protected InetAddress myIPAddress = null;
    protected volatile HashMap<String, HostEntry>hostCache = new HashMap<String, HostEntry>();

    public abstract void run();
   

    /**
	* Join P2P-MPI group by contacting SuperNode
	* @author choopan
	* @param supernode the URI of the supernode to join. Should be provided through config. file.
	* @return returns true if we could register, false otherwise
	**/
    protected boolean joinMpiGroup(URI superNode) {
		int count = 10;
		while(count-- > 0) {
			  try {
				    Socket sock = new Socket();
				    InetSocketAddress addr = new InetSocketAddress(superNode.getHost(), superNode.getPort());
				    sock.connect(addr, 1000);
				    RegisterMessage msg = new RegisterMessage(myHost);
				    OutputStream out = sock.getOutputStream();
				    ObjectOutputStream oos = new ObjectOutputStream(out);
				    oos.writeObject(msg);
				    oos.flush();
				    oos.close();
				    out.close();
				    sock.close();
				    return true;
			  } catch(Exception e) {
				    try {
						Thread.sleep(1000);
				    } catch(Exception ee) {}
			  }
		}
		return false;
    }

    protected void updateHostCache(URI superNode) {
	    try {
		log.info("Waiting for SuperNode " + superNode.getHost() +":"+ superNode.getPort() + " host list ..." );
		Socket sock = new Socket(superNode.getHost(), superNode.getPort());
		PeerRequestMessage msg = new PeerRequestMessage();
		InputStream in = sock.getInputStream();
		OutputStream out = sock.getOutputStream();
		ObjectOutputStream oos = new ObjectOutputStream(out);
		oos.writeObject(msg);
		oos.flush();
		ObjectInputStream ois = new ObjectInputStream(in);
		PeerReplyMessage replyMsg = (PeerReplyMessage)ois.readObject();
		ois.close();
		oos.close();
		in.close();
		out.close();
		sock.close();

		Vector<HostEntry> hostList = replyMsg.getHostList();	
		int size = hostList.size();
		log.info("SuperNode sends back a host list (size=" + size +")" );
		for(int i = 0; i < size; i++) {
			HostEntry entry = hostList.elementAt(i);
			String hashMapKey = entry.toString();
			if(entry.toString().equals(myHost.toString())) {
				continue;
			}
			if (!hostCache.containsKey(hashMapKey)) {
				//Ping to update RTT
				PingRTT rttChecker = new PingRTT(entry.getIp(), entry.getMpdPort());
				int rtt = rttChecker.ping();
				entry.setRtt(rtt);
				entry.setAlive(true);
				entry.setLastUpdate();
				
				// Put entry to hashCache
				hostCache.put(hashMapKey, entry);
				log.info("Put new entry to local cache");
			} else {
				//Check last update if pass sometime we ping and keep minimum
				// 5 mins
				if(hostCache.get(hashMapKey).getLastUpdate() > 300000) {
					PingRTT rttChecker = new PingRTT(entry.getIp(), entry.getMpdPort());
					int rtt = rttChecker.ping();
					hostCache.get(hashMapKey).setRtt(rtt);
					hostCache.get(hashMapKey).setLastUpdate();
				}
				hostCache.get(hashMapKey).setAlive(true);
			}
		}
	    } catch(Exception e) {
	    }
    }


} // end class MPDPeer
